/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.RDFDataset;
import org.junit.Assert;
import org.junit.Test;

public class QuadCompareTest {
    private RDFDataset.Quad q = new RDFDataset.Quad("http://example.com/s1", "http://example.com/p1", "http://example.com/o1", "http://example.com/g1");

    @Test
    public void compareToNull() throws Exception {
        Assert.assertNotEquals((long)0L, (long)this.q.compareTo(null));
    }

    @Test
    public void compareToSame() throws Exception {
        RDFDataset.Quad q2 = new RDFDataset.Quad("http://example.com/s1", "http://example.com/p1", "http://example.com/o1", "http://example.com/g1");
        Assert.assertEquals((long)0L, (long)this.q.compareTo(q2));
        q2.put((Object)"example", (Object)"value");
        Assert.assertEquals((long)0L, (long)this.q.compareTo(q2));
    }

    @Test
    public void compareToDifferentGraph() throws Exception {
        RDFDataset.Quad q2 = new RDFDataset.Quad("http://example.com/s1", "http://example.com/p1", "http://example.com/o1", "http://example.com/other");
        Assert.assertNotEquals((long)0L, (long)this.q.compareTo(q2));
    }

    @Test
    public void compareToDifferentSubject() throws Exception {
        RDFDataset.Quad q2 = new RDFDataset.Quad("http://example.com/other", "http://example.com/p1", "http://example.com/o1", "http://example.com/g1");
        Assert.assertNotEquals((long)0L, (long)this.q.compareTo(q2));
    }

    @Test
    public void compareToDifferentPredicate() throws Exception {
        RDFDataset.Quad q2 = new RDFDataset.Quad("http://example.com/s1", "http://example.com/other", "http://example.com/o1", "http://example.com/g1");
        Assert.assertNotEquals((long)0L, (long)this.q.compareTo(q2));
    }

    @Test
    public void compareToDifferentObject() throws Exception {
        RDFDataset.Quad q2 = new RDFDataset.Quad("http://example.com/s1", "http://example.com/p1", "http://example.com/other", "http://example.com/g1");
        Assert.assertNotEquals((long)0L, (long)this.q.compareTo(q2));
    }

    @Test
    public void compareToDifferentObjectType() throws Exception {
        RDFDataset.Quad q2 = new RDFDataset.Quad("http://example.com/s1", "http://example.com/p1", "http://example.com/other", null, null, "http://example.com/g1");
        Assert.assertNotEquals((long)0L, (long)this.q.compareTo(q2));
    }
}

