/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.utils.Obj;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class JsonLdUtils {
    private static final int MAX_CONTEXT_URLS = 10;

    private JsonLdUtils() {
    }

    static boolean isKeyword(Object key) {
        return JsonLdUtils.isString(key) != false && ("@base".equals(key) || "@context".equals(key) || "@container".equals(key) || "@default".equals(key) || "@embed".equals(key) || "@explicit".equals(key) || "@graph".equals(key) || "@id".equals(key) || "@index".equals(key) || "@language".equals(key) || "@list".equals(key) || "@omitDefault".equals(key) || "@reverse".equals(key) || "@preserve".equals(key) || "@set".equals(key) || "@type".equals(key) || "@value".equals(key) || "@vocab".equals(key));
    }

    private static Boolean deepCompare(Object v1, Object v2, Boolean listOrderMatters) {
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return v1 == null;
        }
        if (v1 instanceof Map && v2 instanceof Map) {
            Map m1 = (Map)v1;
            Map m2 = (Map)v2;
            if (m1.size() != m2.size()) {
                return false;
            }
            for (String key : m1.keySet()) {
                if (m2.containsKey(key) && JsonLdUtils.deepCompare(m1.get(key), m2.get(key), listOrderMatters).booleanValue()) continue;
                return false;
            }
            return true;
        }
        if (v1 instanceof List && v2 instanceof List) {
            List l1 = (List)v1;
            List l2 = (List)v2;
            if (l1.size() != l2.size()) {
                return false;
            }
            boolean[] alreadyMatched = new boolean[l2.size()];
            for (int i = 0; i < l1.size(); ++i) {
                Object o1 = l1.get(i);
                Boolean gotmatch = false;
                if (listOrderMatters.booleanValue()) {
                    gotmatch = JsonLdUtils.deepCompare(o1, l2.get(i), listOrderMatters);
                } else {
                    for (int j = 0; j < l2.size(); ++j) {
                        if (alreadyMatched[j] || !JsonLdUtils.deepCompare(o1, l2.get(j), listOrderMatters).booleanValue()) continue;
                        alreadyMatched[j] = true;
                        gotmatch = true;
                        break;
                    }
                }
                if (gotmatch.booleanValue()) continue;
                return false;
            }
            return true;
        }
        return v1.equals(v2);
    }

    static Boolean deepCompare(Object v1, Object v2) {
        return JsonLdUtils.deepCompare(v1, v2, false);
    }

    private static boolean deepContains(List<Object> values, Object value) {
        for (Object item : values) {
            if (!JsonLdUtils.deepCompare(item, value, false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    static void mergeValue(Map<String, Object> obj, String key, Object value) {
        if (obj == null) {
            return;
        }
        ArrayList<Object> values = (ArrayList<Object>)obj.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            obj.put(key, values);
        }
        if ("@list".equals(key) || value instanceof Map && ((Map)value).containsKey("@list") || !JsonLdUtils.deepContains(values, value)) {
            values.add(value);
        }
    }

    static void laxMergeValue(Map<String, Object> obj, String key, Object value) {
        if (obj == null) {
            return;
        }
        ArrayList<Object> values = (ArrayList<Object>)obj.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            obj.put(key, values);
        }
        values.add(value);
    }

    static boolean isAbsoluteIri(String value) {
        return value.contains(":");
    }

    static boolean isNode(Object v) {
        return v instanceof Map && !((Map)v).containsKey("@value") && !((Map)v).containsKey("@set") && !((Map)v).containsKey("@list") && (((Map)v).size() > 1 || !((Map)v).containsKey("@id"));
    }

    static boolean isNodeReference(Object v) {
        return v instanceof Map && ((Map)v).size() == 1 && ((Map)v).containsKey("@id");
    }

    static boolean isRelativeIri(String value) {
        return !JsonLdUtils.isKeyword(value) && !JsonLdUtils.isAbsoluteIri(value);
    }

    static Object removePreserve(Context ctx, Object input, JsonLdOptions opts) throws JsonLdError {
        if (JsonLdUtils.isArray(input).booleanValue()) {
            ArrayList<Object> output = new ArrayList<Object>();
            for (Object i : (List)input) {
                Object result = JsonLdUtils.removePreserve(ctx, i, opts);
                if (result == null) continue;
                output.add(result);
            }
            input = output;
        } else if (JsonLdUtils.isObject(input).booleanValue()) {
            if (((Map)((Object)input)).containsKey("@preserve")) {
                if ("@null".equals(((Map)((Object)input)).get("@preserve"))) {
                    return null;
                }
                return ((Map)((Object)input)).get("@preserve");
            }
            if (JsonLdUtils.isValue(input).booleanValue()) {
                return input;
            }
            if (JsonLdUtils.isList(input).booleanValue()) {
                ((Map)((Object)input)).put("@list", JsonLdUtils.removePreserve(ctx, ((Map)((Object)input)).get("@list"), opts));
                return input;
            }
            for (String prop : ((Map)((Object)input)).keySet()) {
                Object result = JsonLdUtils.removePreserve(ctx, ((Map)((Object)input)).get(prop), opts);
                String container = ctx.getContainer(prop);
                if (opts.getCompactArrays().booleanValue() && JsonLdUtils.isArray(result).booleanValue() && ((List)result).size() == 1 && container == null) {
                    result = ((List)result).get(0);
                }
                ((Map)((Object)input)).put(prop, result);
            }
        }
        return input;
    }

    static int compareShortestLeast(String a, String b) {
        if (a.length() < b.length()) {
            return -1;
        }
        if (b.length() < a.length()) {
            return 1;
        }
        return Integer.signum(a.compareTo(b));
    }

    static boolean compareValues(Object v1, Object v2) {
        return v1.equals(v2) || JsonLdUtils.isValue(v1) != false && JsonLdUtils.isValue(v2) != false && Obj.equals(((Map)v1).get("@value"), ((Map)v2).get("@value")) && Obj.equals(((Map)v1).get("@type"), ((Map)v2).get("@type")) && Obj.equals(((Map)v1).get("@language"), ((Map)v2).get("@language")) && Obj.equals(((Map)v1).get("@index"), ((Map)v2).get("@index")) || v1 instanceof Map && ((Map)v1).containsKey("@id") && v2 instanceof Map && ((Map)v2).containsKey("@id") && ((Map)v1).get("@id").equals(((Map)v2).get("@id"));
    }

    static boolean isBlankNode(Object v) {
        if (v instanceof Map) {
            if (((Map)v).containsKey("@id")) {
                return ((String)((Map)v).get("@id")).startsWith("_:");
            }
            return ((Map)v).size() == 0 || !((Map)v).containsKey("@value") && !((Map)v).containsKey("@set") && !((Map)v).containsKey("@list");
        }
        return false;
    }

    static Object clone(Object value) {
        Object rval = null;
        if (value instanceof Cloneable) {
            try {
                rval = value.getClass().getMethod("clone", new Class[0]).invoke(value, new Object[0]);
            }
            catch (Exception e) {
                rval = e;
            }
        }
        if (rval == null || rval instanceof Exception) {
            if (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) {
                rval = value;
            } else {
                throw new RuntimeException(new CloneNotSupportedException(rval != null ? ((Exception)rval).getMessage() : ""));
            }
        }
        return rval;
    }

    private static Boolean isArray(Object v) {
        return v instanceof List;
    }

    static Boolean isList(Object v) {
        return v instanceof Map && ((Map)v).containsKey("@list");
    }

    static Boolean isObject(Object v) {
        return v instanceof Map;
    }

    static Boolean isValue(Object v) {
        return v instanceof Map && ((Map)v).containsKey("@value");
    }

    static Boolean isString(Object v) {
        return v instanceof String;
    }
}

