/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdUtils;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFDatasetUtils;
import com.github.jsonldjava.core.UniqueNamer;
import com.github.jsonldjava.utils.Obj;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class NormalizeUtils {
    private final UniqueNamer namer;
    private final Map<String, Object> bnodes;
    private final List<Object> quads;
    private final JsonLdOptions options;

    NormalizeUtils(List<Object> quads, Map<String, Object> bnodes, UniqueNamer namer, JsonLdOptions options) {
        this.options = options;
        this.quads = quads;
        this.bnodes = bnodes;
        this.namer = namer;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    Object hashBlankNodes(Collection<String> unnamed_) throws JsonLdError {
        ArrayList hashes;
        ArrayList<String> arrayList = new ArrayList<String>(unnamed_);
        ArrayList<String> nextUnnamed = new ArrayList<String>();
        LinkedHashMap duplicates = new LinkedHashMap();
        LinkedHashMap<String, String> unique = new LinkedHashMap<String, String>();
        int hui = 0;
        while (true) {
            void var2_3;
            if (hui == var2_3.size()) {
                Boolean named = false;
                hashes = new ArrayList(unique.keySet());
                Collections.sort(hashes);
                for (String hash : hashes) {
                    String bnode = (String)unique.get(hash);
                    this.namer.getName(bnode);
                    named = true;
                }
                if (!named.booleanValue()) break;
                hui = -1;
                ArrayList<String> arrayList2 = nextUnnamed;
                nextUnnamed = new ArrayList();
                duplicates = new LinkedHashMap();
                unique = new LinkedHashMap();
            } else {
                String bnode = (String)var2_3.get(hui);
                String hash = NormalizeUtils.hashQuads(bnode, this.bnodes, this.namer);
                if (duplicates.containsKey(hash)) {
                    ((List)duplicates.get(hash)).add(bnode);
                    nextUnnamed.add(bnode);
                } else if (unique.containsKey(hash)) {
                    ArrayList<Object> tmp = new ArrayList<Object>();
                    tmp.add(unique.get(hash));
                    tmp.add(bnode);
                    duplicates.put(hash, tmp);
                    nextUnnamed.add((String)unique.get(hash));
                    nextUnnamed.add(bnode);
                    unique.remove(hash);
                } else {
                    unique.put(hash, bnode);
                }
            }
            ++hui;
        }
        hashes = new ArrayList(duplicates.keySet());
        Collections.sort(hashes);
        int pgi = 0;
        while (true) {
            if (pgi == hashes.size()) {
                StringBuilder rval;
                Object quad12;
                ArrayList<String> normalized = new ArrayList<String>();
                for (Object quad12 : this.quads) {
                    Map map = (Map)quad12;
                    for (String attr : new String[]{"subject", "object", "name"}) {
                        Map qa;
                        if (!map.containsKey(attr) || (qa = (Map)map.get(attr)) == null || !"blank node".equals(qa.get("type")) || ((String)qa.get("value")).indexOf("_:c14n") == 0) continue;
                        qa.put("value", this.namer.getName((String)qa.get("value")));
                    }
                    normalized.add(RDFDatasetUtils.toNQuad((RDFDataset.Quad)map, map.containsKey("name") && map.get("name") != null ? (String)((Map)map.get("name")).get("value") : null));
                }
                Collections.sort(normalized);
                if (this.options.format != null) {
                    if (!"application/n-quads".equals(this.options.format)) {
                        throw new JsonLdError(JsonLdError.Error.UNKNOWN_FORMAT, this.options.format);
                    }
                    rval = new StringBuilder();
                    quad12 = normalized.iterator();
                    while (true) {
                        if (!quad12.hasNext()) {
                            return rval.toString();
                        }
                        String string = (String)quad12.next();
                        rval.append(string);
                    }
                }
                rval = new StringBuilder();
                quad12 = normalized.iterator();
                while (true) {
                    if (!quad12.hasNext()) {
                        return RDFDatasetUtils.parseNQuads(rval.toString());
                    }
                    String string = (String)quad12.next();
                    rval.append(string);
                }
            }
            List group = (List)duplicates.get(hashes.get(pgi));
            ArrayList<HashResult> results = new ArrayList<HashResult>();
            int n = 0;
            while (true) {
                if (n == group.size()) {
                    results.sort(Comparator.comparing(a -> a.hash));
                    for (HashResult r : results) {
                        for (String key : r.pathNamer.existing().keySet()) {
                            this.namer.getName(key);
                        }
                    }
                    break;
                }
                String string = (String)group.get(n);
                if (!this.namer.isNamed(string).booleanValue()) {
                    UniqueNamer pathNamer = new UniqueNamer("_:b");
                    pathNamer.getName(string);
                    HashResult result = NormalizeUtils.hashPaths(string, this.bnodes, this.namer, pathNamer);
                    results.add(result);
                }
                ++n;
            }
            ++pgi;
        }
    }

    private static HashResult hashPaths(String id, Map<String, Object> bnodes, UniqueNamer namer, UniqueNamer pathNamer) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            LinkedHashMap groups = new LinkedHashMap();
            List quads = (List)((Map)bnodes.get(id)).get("quads");
            int hpi = 0;
            while (true) {
                if (hpi == quads.size()) {
                    ArrayList groupHashes = new ArrayList(groups.keySet());
                    Collections.sort(groupHashes);
                    int hgi = 0;
                    while (true) {
                        if (hgi == groupHashes.size()) {
                            HashResult res = new HashResult();
                            res.hash = NormalizeUtils.encodeHex(md.digest());
                            res.pathNamer = pathNamer;
                            return res;
                        }
                        String groupHash = (String)groupHashes.get(hgi);
                        md.update(groupHash.getBytes("UTF-8"));
                        String chosenPath = null;
                        UniqueNamer chosenNamer = null;
                        Permutator permutator = new Permutator((List)groups.get(groupHash));
                        while (true) {
                            Boolean contPermutation = false;
                            Boolean breakOut = false;
                            List<String> permutation = permutator.next();
                            UniqueNamer pathNamerCopy = pathNamer.clone();
                            StringBuilder path = new StringBuilder();
                            ArrayList<String> recurse = new ArrayList<String>();
                            for (String bnode : permutation) {
                                if (namer.isNamed(bnode).booleanValue()) {
                                    path.append(namer.getName(bnode));
                                } else {
                                    if (!pathNamerCopy.isNamed(bnode).booleanValue()) {
                                        recurse.add(bnode);
                                    }
                                    path.append(pathNamerCopy.getName(bnode));
                                }
                                if (chosenPath == null || path.length() < chosenPath.length() || path.toString().compareTo(chosenPath) <= 0) continue;
                                if (permutator.hasNext()) {
                                    contPermutation = true;
                                    break;
                                }
                                md.update(chosenPath.getBytes("UTF-8"));
                                pathNamer = chosenNamer;
                                breakOut = true;
                                break;
                            }
                            if (contPermutation.booleanValue()) continue;
                            if (breakOut.booleanValue()) break;
                            int nrn = 0;
                            while (true) {
                                String bnode;
                                if (nrn == recurse.size()) {
                                    if (chosenPath == null || path.toString().compareTo(chosenPath) < 0) {
                                        chosenPath = path.toString();
                                        chosenNamer = pathNamerCopy;
                                    }
                                    if (permutator.hasNext()) break;
                                    md.update(chosenPath.getBytes("UTF-8"));
                                    pathNamer = chosenNamer;
                                    breakOut = true;
                                    break;
                                }
                                bnode = (String)recurse.get(nrn);
                                HashResult result = NormalizeUtils.hashPaths(bnode, bnodes, namer, pathNamerCopy);
                                path.append(pathNamerCopy.getName(bnode)).append("<").append(result.hash).append(">");
                                pathNamerCopy = result.pathNamer;
                                if (chosenPath != null && path.length() >= chosenPath.length() && path.toString().compareTo(chosenPath) > 0) {
                                    if (permutator.hasNext()) break;
                                    md.update(chosenPath.getBytes("UTF-8"));
                                    pathNamer = chosenNamer;
                                    breakOut = true;
                                    break;
                                }
                                ++nrn;
                            }
                            if (breakOut.booleanValue()) break;
                        }
                        ++hgi;
                    }
                }
                Map quad = (Map)quads.get(hpi);
                String bnode = NormalizeUtils.getAdjacentBlankNodeName((Map)quad.get("subject"), id);
                String direction = null;
                if (bnode != null) {
                    direction = "p";
                } else {
                    bnode = NormalizeUtils.getAdjacentBlankNodeName((Map)quad.get("object"), id);
                    if (bnode != null) {
                        direction = "r";
                    }
                }
                if (bnode != null) {
                    String name = namer.isNamed(bnode) != false ? namer.getName(bnode) : (pathNamer.isNamed(bnode) != false ? pathNamer.getName(bnode) : NormalizeUtils.hashQuads(bnode, bnodes, namer));
                    MessageDigest md1 = MessageDigest.getInstance("SHA-1");
                    md1.update(direction.getBytes("UTF-8"));
                    md1.update(((String)((Map)quad.get("predicate")).get("value")).getBytes("UTF-8"));
                    md1.update(name.getBytes("UTF-8"));
                    String groupHash = NormalizeUtils.encodeHex(md1.digest());
                    if (groups.containsKey(groupHash)) {
                        ((List)groups.get(groupHash)).add(bnode);
                    } else {
                        ArrayList<String> tmp = new ArrayList<String>();
                        tmp.add(bnode);
                        groups.put(groupHash, tmp);
                    }
                }
                ++hpi;
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String hashQuads(String id, Map<String, Object> bnodes, UniqueNamer namer) {
        if (((Map)bnodes.get(id)).containsKey("hash")) {
            return (String)((Map)bnodes.get(id)).get("hash");
        }
        List quads = (List)((Map)bnodes.get(id)).get("quads");
        ArrayList<String> nquads = new ArrayList<String>();
        for (Map quad : quads) {
            nquads.add(RDFDatasetUtils.toNQuad((RDFDataset.Quad)quad, quad.get("name") != null ? (String)((Map)quad.get("name")).get("value") : null, id));
        }
        Collections.sort(nquads);
        String hash = NormalizeUtils.sha1hash(nquads);
        ((Map)bnodes.get(id)).put("hash", hash);
        return hash;
    }

    private static String sha1hash(Collection<String> nquads) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            for (String nquad : nquads) {
                md.update(nquad.getBytes("UTF-8"));
            }
            return NormalizeUtils.encodeHex(md.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String encodeHex(byte[] data) {
        StringBuilder rval = new StringBuilder();
        for (byte b : data) {
            rval.append(String.format("%02x", b));
        }
        return rval.toString();
    }

    private static String getAdjacentBlankNodeName(Map<String, Object> node, String id) {
        return "blank node".equals(node.get("type")) && (!node.containsKey("value") || !Obj.equals(node.get("value"), id)) ? (String)node.get("value") : null;
    }

    private static class Permutator {
        private final List<String> list;
        private boolean done;
        private final Map<String, Boolean> left;

        Permutator(List<String> list) {
            this.list = (List)JsonLdUtils.clone(list);
            Collections.sort(this.list);
            this.done = false;
            this.left = new LinkedHashMap<String, Boolean>();
            for (String i : this.list) {
                this.left.put(i, true);
            }
        }

        boolean hasNext() {
            return !this.done;
        }

        public List<String> next() {
            List rval = (List)JsonLdUtils.clone(this.list);
            String k = null;
            int pos = 0;
            int length = this.list.size();
            for (int i = 0; i < length; ++i) {
                String element = this.list.get(i);
                Boolean left = this.left.get(element);
                if (k != null && element.compareTo(k) <= 0 || (!left.booleanValue() || i <= 0 || element.compareTo(this.list.get(i - 1)) <= 0) && (left.booleanValue() || i >= length - 1 || element.compareTo(this.list.get(i + 1)) <= 0)) continue;
                k = element;
                pos = i;
            }
            if (k == null) {
                this.done = true;
            } else {
                int swap = this.left.get(k) != false ? pos - 1 : pos + 1;
                this.list.set(pos, this.list.get(swap));
                this.list.set(swap, k);
                for (String aList : this.list) {
                    if (aList.compareTo(k) <= 0) continue;
                    this.left.put(aList, this.left.get(aList) == false);
                }
            }
            return rval;
        }
    }

    private static class HashResult {
        String hash;
        UniqueNamer pathNamer;

        private HashResult() {
        }
    }
}

