/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import java.net.URL;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Test;

public class ArrayContextToRDFTest {
    @Test
    public void toRdfWithNamespace() throws Exception {
        URL contextUrl = this.getClass().getResource("/custom/contexttest-0001.jsonld");
        Assert.assertNotNull((Object)contextUrl);
        final Object context = JsonUtils.fromURL((URL)contextUrl, (CloseableHttpClient)JsonUtils.getDefaultHttpClient());
        Assert.assertNotNull((Object)context);
        URL arrayContextUrl = this.getClass().getResource("/custom/array-context.jsonld");
        Assert.assertNotNull((Object)arrayContextUrl);
        Object arrayContext = JsonUtils.fromURL((URL)arrayContextUrl, (CloseableHttpClient)JsonUtils.getDefaultHttpClient());
        Assert.assertNotNull((Object)arrayContext);
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        DocumentLoader documentLoader = new DocumentLoader(){

            public RemoteDocument loadDocument(String url) throws JsonLdError {
                return new RemoteDocument("http://nonexisting.example.com/context", context);
            }
        };
        options.setDocumentLoader(documentLoader);
        RDFDataset rdf = (RDFDataset)JsonLdProcessor.toRDF((Object)arrayContext, (JsonLdOptions)options);
        Assert.assertEquals((Object)"http://example.org/", (Object)rdf.getNamespace("ex"));
        Assert.assertEquals((Object)"http://example.com/2/", (Object)rdf.getNamespace("ex2"));
        Assert.assertFalse((boolean)rdf.getNamespaces().containsKey("term1"));
    }
}

