/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class DocumentLoaderTest {
    private final DocumentLoader documentLoader = new DocumentLoader();

    @After
    public void setContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    @Test
    public void fromURLTest0001() throws Exception {
        URL contexttest = this.getClass().getResource("/custom/contexttest-0001.jsonld");
        Assert.assertNotNull((Object)contexttest);
        Object context = JsonUtils.fromURL((URL)contexttest, (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertTrue((boolean)(context instanceof Map));
        Map contextMap = (Map)context;
        Assert.assertEquals((long)1L, (long)contextMap.size());
        Map cont = (Map)contextMap.get("@context");
        Assert.assertEquals((long)3L, (long)cont.size());
        Assert.assertEquals((Object)"http://example.org/", cont.get("ex"));
        Map term1 = (Map)cont.get("term1");
        Assert.assertEquals((Object)"ex:term1", term1.get("@id"));
    }

    @Test
    public void fromURLTest0002() throws Exception {
        URL contexttest = this.getClass().getResource("/custom/contexttest-0002.jsonld");
        Assert.assertNotNull((Object)contexttest);
        Object context = JsonUtils.fromURL((URL)contexttest, (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertTrue((boolean)(context instanceof List));
        List contextList = (List)context;
        Map contextMap1 = (Map)contextList.get(0);
        Assert.assertEquals((long)1L, (long)contextMap1.size());
        Map cont1 = (Map)contextMap1.get("@context");
        Assert.assertEquals((long)2L, (long)cont1.size());
        Assert.assertEquals((Object)"http://example.org/", cont1.get("ex"));
        Map term1 = (Map)cont1.get("term1");
        Assert.assertEquals((Object)"ex:term1", term1.get("@id"));
        Map contextMap2 = (Map)contextList.get(1);
        Assert.assertEquals((long)1L, (long)contextMap2.size());
        Map cont2 = (Map)contextMap2.get("@context");
        Assert.assertEquals((long)1L, (long)cont2.size());
        Map term2 = (Map)cont2.get("term2");
        Assert.assertEquals((Object)"ex:term2", term2.get("@id"));
    }

    @Test
    public void fromURLredirectHTTPSToHTTP() throws Exception {
        URL url = new URL("https://w3id.org/bundle/context");
        Object context = JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    @Test
    public void fromURLredirect() throws Exception {
        URL url = new URL("http://purl.org/wf4ever/ro-bundle/context.json");
        Object context = JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    @Test
    public void loadDocumentWf4ever() throws Exception {
        RemoteDocument document = this.documentLoader.loadDocument("http://purl.org/wf4ever/ro-bundle/context.json");
        Object context = document.getDocument();
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    @Test
    public void fromURLSchemaOrgNoApacheHttpClient() throws Exception {
        URL url = new URL("http://schema.org/");
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.addRequestProperty("Accept", "application/ld+json");
        StringWriter output = new StringWriter();
        try (InputStream directStream = urlConn.getInputStream();){
            IOUtils.copy((InputStream)directStream, (Writer)output, (Charset)Charset.forName("UTF-8"));
        }
        Object context = JsonUtils.fromReader((Reader)new StringReader(output.toString()));
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    @Test
    public void loadDocumentSchemaOrg() throws Exception {
        RemoteDocument document = this.documentLoader.loadDocument("http://schema.org/");
        Object context = document.getDocument();
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    @Test
    public void loadDocumentSchemaOrgDirect() throws Exception {
        RemoteDocument document = this.documentLoader.loadDocument("http://schema.org/docs/jsonldcontext.json");
        Object context = document.getDocument();
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    @Test
    public void fromURLCache() throws Exception {
        URL url = new URL("http://json-ld.org/contexts/person.jsonld");
        JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
        CloseableHttpClient clientCached = this.documentLoader.getHttpClient();
        HttpGet getCached = new HttpGet(url.toURI());
        getCached.setHeader("Accept", "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1");
        HttpCacheContext localContextCached = HttpCacheContext.create();
        HttpResponse respoCached = clientCached.execute((HttpUriRequest)getCached, (HttpContext)localContextCached);
        EntityUtils.consume((HttpEntity)respoCached.getEntity());
        CacheResponseStatus responseStatusCached = localContextCached.getCacheResponseStatus();
        Assert.assertNotEquals((Object)CacheResponseStatus.CACHE_MISS, (Object)responseStatusCached);
    }

    @Test
    public void fromURLCustomHandler() throws Exception {
        final AtomicInteger requests = new AtomicInteger();
        URLStreamHandler handler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return new URLConnection(u){

                    @Override
                    public void connect() throws IOException {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        requests.incrementAndGet();
                        return this.getClass().getResourceAsStream("/custom/contexttest-0001.jsonld");
                    }
                };
            }
        };
        URL url = new URL(null, "jsonldtest:context", handler);
        Assert.assertEquals((long)0L, (long)requests.get());
        Object context = JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertEquals((long)1L, (long)requests.get());
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertFalse((boolean)((Map)context).isEmpty());
    }

    private CloseableHttpClient fakeHttpClient(ArgumentCaptor<HttpUriRequest> httpRequest) throws IllegalStateException, IOException {
        CloseableHttpClient httpClient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        CloseableHttpResponse fakeResponse = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine statusCode = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)statusCode.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)fakeResponse.getStatusLine()).thenReturn((Object)statusCode);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)DocumentLoaderTest.class.getResourceAsStream("/custom/contexttest-0001.jsonld"));
        Mockito.when((Object)fakeResponse.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)httpClient.execute((HttpUriRequest)httpRequest.capture())).thenReturn((Object)fakeResponse);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fromURLAcceptHeaders() throws Exception {
        URL url = new URL("http://example.com/fake-jsonld-test");
        ArgumentCaptor httpRequest = ArgumentCaptor.forClass(HttpUriRequest.class);
        this.documentLoader.setHttpClient(this.fakeHttpClient((ArgumentCaptor<HttpUriRequest>)httpRequest));
        try {
            Object context = JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
            Assert.assertTrue((boolean)(context instanceof Map));
        }
        finally {
            this.documentLoader.setHttpClient(null);
            Assert.assertSame((Object)this.documentLoader.getHttpClient(), (Object)new DocumentLoader().getHttpClient());
        }
        Assert.assertEquals((long)1L, (long)httpRequest.getAllValues().size());
        HttpUriRequest req = (HttpUriRequest)httpRequest.getValue();
        Assert.assertEquals((Object)url.toURI(), (Object)req.getURI());
        Header[] accept = req.getHeaders("Accept");
        Assert.assertEquals((long)1L, (long)accept.length);
        Assert.assertEquals((Object)"application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1", (Object)accept[0].getValue());
        HeaderElement[] elems = accept[0].getElements();
        Assert.assertEquals((Object)"application/ld+json", (Object)elems[0].getName());
        Assert.assertEquals((long)0L, (long)elems[0].getParameterCount());
        Assert.assertEquals((Object)"application/json", (Object)elems[1].getName());
        Assert.assertEquals((long)1L, (long)elems[1].getParameterCount());
        Assert.assertEquals((Object)"0.9", (Object)elems[1].getParameterByName("q").getValue());
        Assert.assertEquals((Object)"application/javascript", (Object)elems[2].getName());
        Assert.assertEquals((long)1L, (long)elems[2].getParameterCount());
        Assert.assertEquals((Object)"0.5", (Object)elems[2].getParameterByName("q").getValue());
        Assert.assertEquals((Object)"text/javascript", (Object)elems[3].getName());
        Assert.assertEquals((long)1L, (long)elems[3].getParameterCount());
        Assert.assertEquals((Object)"0.5", (Object)elems[3].getParameterByName("q").getValue());
        Assert.assertEquals((Object)"text/plain", (Object)elems[4].getName());
        Assert.assertEquals((long)1L, (long)elems[4].getParameterCount());
        Assert.assertEquals((Object)"0.2", (Object)elems[4].getParameterByName("q").getValue());
        Assert.assertEquals((Object)"*/*", (Object)elems[5].getName());
        Assert.assertEquals((long)1L, (long)elems[5].getParameterCount());
        Assert.assertEquals((Object)"0.1", (Object)elems[5].getParameterByName("q").getValue());
        Assert.assertEquals((long)6L, (long)elems.length);
    }

    @Test
    public void jarCacheHit() throws Exception {
        Object context = JsonUtils.fromURL((URL)new URL("http://nonexisting.example.com/context"), (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertTrue((boolean)(context instanceof Map));
        Assert.assertTrue((boolean)((Map)context).containsKey("@context"));
    }

    @Test(expected=IOException.class)
    public void jarCacheMiss404() throws Exception {
        JsonUtils.fromURL((URL)new URL("http://nonexisting.example.com/miss"), (CloseableHttpClient)this.documentLoader.getHttpClient());
    }

    @Test(expected=IOException.class)
    public void jarCacheMissThreadCtx() throws Exception {
        URLClassLoader findNothingCL = new URLClassLoader(new URL[0], null);
        Thread.currentThread().setContextClassLoader(findNothingCL);
        JsonUtils.fromURL((URL)new URL("http://nonexisting.example.com/context"), (CloseableHttpClient)this.documentLoader.getHttpClient());
    }

    @Test
    public void jarCacheHitThreadCtx() throws Exception {
        URL url = new URL("http://nonexisting.example.com/nested/hello");
        URL nestedJar = this.getClass().getResource("/nested.jar");
        try {
            JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
            Assert.fail((String)"Should not be able to find nested/hello yet");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        URLClassLoader cl = new URLClassLoader(new URL[]{nestedJar});
        Thread.currentThread().setContextClassLoader(cl);
        Object hello = JsonUtils.fromURL((URL)url, (CloseableHttpClient)this.documentLoader.getHttpClient());
        Assert.assertTrue((boolean)(hello instanceof Map));
        Assert.assertEquals((Object)"World!", ((Map)hello).get("Hello"));
    }

    @Test
    public void sharedHttpClient() throws Exception {
        Assert.assertSame((Object)this.documentLoader.getHttpClient(), (Object)new DocumentLoader().getHttpClient());
    }

    @Test
    public void differentHttpClient() throws Exception {
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            this.documentLoader.setHttpClient(client);
            Assert.assertNotSame((Object)this.documentLoader.getHttpClient(), (Object)new DocumentLoader().getHttpClient());
        }
        finally {
            this.documentLoader.setHttpClient(null);
            Assert.assertSame((Object)this.documentLoader.getHttpClient(), (Object)new DocumentLoader().getHttpClient());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowRemoteContexts() throws Exception {
        String testUrl = "http://json-ld.org/contexts/person.jsonld";
        RemoteDocument test = this.documentLoader.loadDocument("http://json-ld.org/contexts/person.jsonld");
        Assert.assertNotNull((String)"Was not able to fetch from URL before testing disallow remote contexts loading", (Object)test);
        String disallowProperty = System.getProperty("com.github.jsonldjava.disallowRemoteContextLoading");
        try {
            System.setProperty("com.github.jsonldjava.disallowRemoteContextLoading", "true");
            this.documentLoader.loadDocument("http://json-ld.org/contexts/person.jsonld");
            Assert.fail((String)"Expected exception to occur");
        }
        catch (JsonLdError e) {
            Assert.assertEquals((Object)JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, (Object)e.getType());
        }
        finally {
            if (disallowProperty == null) {
                System.clearProperty("com.github.jsonldjava.disallowRemoteContextLoading");
            } else {
                System.setProperty("com.github.jsonldjava.disallowRemoteContextLoading", disallowProperty);
            }
        }
    }

    @Test
    public void injectContext() throws Exception {
        Object jsonObject = JsonUtils.fromString((String)"{ \"@context\":\"http://nonexisting.example.com/thing\", \"pony\":5 }");
        JsonLdOptions options = new JsonLdOptions();
        try {
            JsonLdProcessor.expand((Object)jsonObject, (JsonLdOptions)options);
            Assert.fail((String)"Expected exception to occur");
        }
        catch (JsonLdError jsonLdError) {
            // empty catch block
        }
        DocumentLoader dl = new DocumentLoader();
        dl.addInjectedDoc("http://nonexisting.example.com/thing", "{ \"@context\": { \"pony\":\"http://nonexisting.example.com/thing/pony\" } }");
        options.setDocumentLoader(dl);
        List expand = JsonLdProcessor.expand((Object)jsonObject, (JsonLdOptions)options);
        Object v = ((Map)((List)((Map)expand.get(0)).get("http://nonexisting.example.com/thing/pony")).get(0)).get("@value");
        Assert.assertEquals((Object)5, v);
    }
}

