/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.github.jsonldjava.utils.JarCacheStorage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class JarCacheTest {
    @Test
    public void cacheHit() throws Exception {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        JarCacheStorage storage = new JarCacheStorage(null, cacheConfig);
        CloseableHttpClient httpClient = JarCacheTest.createTestHttpClient(cacheConfig, storage);
        HttpGet get = new HttpGet("http://nonexisting.example.com/context");
        HttpResponse resp = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((Object)"application/ld+json", (Object)resp.getEntity().getContentType().getValue());
        String str = IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8");
        Assert.assertTrue((boolean)str.contains("ex:datatype"));
    }

    @Test(expected=IOException.class)
    public void cacheMiss() throws Exception {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        JarCacheStorage storage = new JarCacheStorage(null, cacheConfig);
        CloseableHttpClient httpClient = JarCacheTest.createTestHttpClient(cacheConfig, storage);
        HttpGet get = new HttpGet("http://nonexisting.example.com/notfound");
        httpClient.execute((HttpUriRequest)get);
    }

    @Test
    public void doubleLoad() throws Exception {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        JarCacheStorage storage = new JarCacheStorage(null, cacheConfig);
        CloseableHttpClient httpClient = JarCacheTest.createTestHttpClient(cacheConfig, storage);
        HttpGet get = new HttpGet("http://nonexisting.example.com/context");
        HttpResponse resp = httpClient.execute((HttpUriRequest)get);
        resp = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((Object)"application/ld+json", (Object)resp.getEntity().getContentType().getValue());
    }

    @Test
    public void customClassPath() throws Exception {
        URL nestedJar = this.getClass().getResource("/nested.jar");
        URLClassLoader cl = new URLClassLoader(new URL[]{nestedJar});
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        JarCacheStorage storage = new JarCacheStorage((ClassLoader)cl, cacheConfig);
        CloseableHttpClient httpClient = JarCacheTest.createTestHttpClient(cacheConfig, storage);
        HttpGet get = new HttpGet("http://nonexisting.example.com/nested/hello");
        HttpResponse resp = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((Object)"application/json", (Object)resp.getEntity().getContentType().getValue());
        String str = IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8");
        Assert.assertEquals((Object)"{ \"Hello\": \"World!\" }", (Object)str.trim());
    }

    @Test
    public void contextClassLoader() throws Exception {
        URL nestedJar = this.getClass().getResource("/nested.jar");
        Assert.assertNotNull((Object)nestedJar);
        URLClassLoader cl = new URLClassLoader(new URL[]{nestedJar});
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        JarCacheStorage storage = new JarCacheStorage((ClassLoader)cl, cacheConfig);
        Thread.currentThread().setContextClassLoader(cl);
        CloseableHttpClient httpClient = JarCacheTest.createTestHttpClient(cacheConfig, storage);
        HttpGet get = new HttpGet("http://nonexisting.example.com/nested/hello");
        HttpResponse resp = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((Object)"application/json", (Object)resp.getEntity().getContentType().getValue());
        String str = IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8");
        Assert.assertEquals((Object)"{ \"Hello\": \"World!\" }", (Object)str.trim());
    }

    @After
    public void setContextClassLoader() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    @Test
    public void systemClassLoader() throws Exception {
        URL nestedJar = this.getClass().getResource("/nested.jar");
        Assert.assertNotNull((Object)nestedJar);
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        JarCacheStorage storage = new JarCacheStorage(null, cacheConfig);
        CloseableHttpClient httpClient = JarCacheTest.createTestHttpClient(cacheConfig, storage);
        HttpGet get = new HttpGet("http://nonexisting.example.com/context");
        HttpResponse resp = httpClient.execute((HttpUriRequest)get);
        Assert.assertEquals((Object)"application/ld+json", (Object)resp.getEntity().getContentType().getValue());
    }

    private static CloseableHttpClient createTestHttpClient(CacheConfig cacheConfig, JarCacheStorage jarCacheConfig) {
        CloseableHttpClient result = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setHttpCacheStorage((HttpCacheStorage)jarCacheConfig).addInterceptorFirst((HttpRequestInterceptor)new RequestAcceptEncoding()).addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding()).setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE).useSystemProperties().build();
        return result;
    }
}

