/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class UniqueNamer {
    private final String prefix;
    private int counter;
    private Map<String, String> existing;

    UniqueNamer(String prefix) {
        this.prefix = prefix;
        this.counter = 0;
        this.existing = new LinkedHashMap<String, String>();
    }

    public UniqueNamer clone() {
        UniqueNamer copy = new UniqueNamer(this.prefix);
        copy.counter = this.counter;
        copy.existing = (Map)JsonLdUtils.clone(this.existing);
        return copy;
    }

    String getName(String oldName) {
        if (oldName != null && this.existing.containsKey(oldName)) {
            return this.existing.get(oldName);
        }
        String name = this.prefix + this.counter;
        ++this.counter;
        if (oldName != null) {
            this.existing.put(oldName, name);
        }
        return name;
    }

    public String getName() {
        return this.getName(null);
    }

    Boolean isNamed(String oldName) {
        return this.existing.containsKey(oldName);
    }

    Map<String, String> existing() {
        return this.existing;
    }
}

