/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.RDFDataset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class NodeCompareTest {
    @Test
    public void ordered() throws Exception {
        List<RDFDataset.Node> expected = Arrays.asList(new RDFDataset.Literal("1", "http://www.w3.org/2001/XMLSchema#integer", null), new RDFDataset.Literal("10", "http://www.w3.org/2001/XMLSchema#integer", null), new RDFDataset.Literal("2", "http://www.w3.org/2001/XMLSchema#integer", null), new RDFDataset.Literal("a", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en"), new RDFDataset.Literal("a", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "fr"), new RDFDataset.Literal("a", null, null), new RDFDataset.Literal("b", "http://www.w3.org/2001/XMLSchema#string", null), new RDFDataset.Literal("false", "http://www.w3.org/2001/XMLSchema#boolean", null), new RDFDataset.Literal("true", "http://www.w3.org/2001/XMLSchema#boolean", null), new RDFDataset.Literal("x", "http://www.w3.org/2001/XMLSchema#string", null), new RDFDataset.Literal("z", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en"), new RDFDataset.Literal("z", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "fr"), new RDFDataset.Literal("z", null, null), new RDFDataset.BlankNode("a"), new RDFDataset.BlankNode("f"), new RDFDataset.BlankNode("z"), new RDFDataset.IRI("http://example.com/ex1"), new RDFDataset.IRI("http://example.com/ex2"), new RDFDataset.IRI("http://example.org/ex"), new RDFDataset.IRI("https://example.net/"));
        ArrayList<RDFDataset.Node> shuffled = new ArrayList<RDFDataset.Node>(expected);
        Random rand = new Random(1337L);
        Collections.shuffle(shuffled, rand);
        Assert.assertNotEquals(expected, shuffled);
        Collections.sort(shuffled);
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((String)("Wrong sort order at position " + i), (Object)expected.get(i), shuffled.get(i));
        }
    }

    @Test
    public void literalSameValue() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("Same", null, null);
        RDFDataset.Literal l2 = new RDFDataset.Literal("Same", null, null);
        Assert.assertEquals((Object)l1, (Object)l2);
        Assert.assertEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalDifferentValue() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("Same", null, null);
        RDFDataset.Literal l2 = new RDFDataset.Literal("Different", null, null);
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Assert.assertNotEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalSameValueSameLang() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
        RDFDataset.Literal l2 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
        Assert.assertEquals((Object)l1, (Object)l2);
        Assert.assertEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalDifferentValueSameLang() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
        RDFDataset.Literal l2 = new RDFDataset.Literal("Different", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Assert.assertNotEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalSameValueDifferentLang() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
        RDFDataset.Literal l2 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "no");
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Assert.assertNotEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalSameValueLangNull() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
        RDFDataset.Literal l2 = new RDFDataset.Literal("Same", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", null);
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Assert.assertNotEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
        Assert.assertNotEquals((long)0L, (long)l2.compareTo((RDFDataset.Node)l1));
    }

    @Test
    public void literalSameValueSameType() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("1", "http://www.w3.org/2001/XMLSchema#integer", null);
        RDFDataset.Literal l2 = new RDFDataset.Literal("1", "http://www.w3.org/2001/XMLSchema#integer", null);
        Assert.assertEquals((Object)l1, (Object)l2);
        Assert.assertEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalSameValueSameTypeNull() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("1", "http://www.w3.org/2001/XMLSchema#string", null);
        RDFDataset.Literal l2 = new RDFDataset.Literal("1", null, null);
        Assert.assertEquals((Object)l1, (Object)l2);
        Assert.assertEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalSameValueDifferentType() throws Exception {
        RDFDataset.Literal l1 = new RDFDataset.Literal("1", "http://www.w3.org/2001/XMLSchema#integer", null);
        RDFDataset.Literal l2 = new RDFDataset.Literal("1", "http://www.w3.org/2001/XMLSchema#string", null);
        Assert.assertNotEquals((Object)l1, (Object)l2);
        Assert.assertNotEquals((long)0L, (long)l1.compareTo((RDFDataset.Node)l2));
    }

    @Test
    public void literalsInDataset() throws Exception {
        RDFDataset dataset = new RDFDataset();
        dataset.addQuad("http://example.com/p", "http://example.com/p", "Same", null, null, "http://example.com/g1");
        dataset.addQuad("http://example.com/p", "http://example.com/p", "Different", null, null, "http://example.com/g1");
        List quads = dataset.getQuads("http://example.com/g1");
        RDFDataset.Quad q1 = (RDFDataset.Quad)quads.get(0);
        RDFDataset.Quad q2 = (RDFDataset.Quad)quads.get(1);
        Assert.assertNotEquals((Object)q1, (Object)q2);
        Assert.assertNotEquals((long)0L, (long)q1.compareTo(q2));
        Assert.assertNotEquals((long)0L, (long)q1.getObject().compareTo(q2.getObject()));
    }

    @Test
    public void iriDifferentLiteral() throws Exception {
        RDFDataset.IRI iri = new RDFDataset.IRI("http://example.com/");
        RDFDataset.Literal literal = new RDFDataset.Literal("http://example.com/", null, null);
        Assert.assertNotEquals((Object)iri, (Object)literal);
        Assert.assertNotEquals((long)0L, (long)iri.compareTo((RDFDataset.Node)literal));
        Assert.assertNotEquals((long)0L, (long)literal.compareTo((RDFDataset.Node)iri));
    }

    @Test
    public void iriDifferentNull() throws Exception {
        RDFDataset.IRI iri = new RDFDataset.IRI("http://example.com/");
        Assert.assertNotEquals((long)0L, (long)iri.compareTo(null));
    }

    @Test
    public void literalDifferentNull() throws Exception {
        RDFDataset.Literal literal = new RDFDataset.Literal("hello", null, null);
        Assert.assertNotEquals((long)0L, (long)literal.compareTo(null));
    }

    @Test
    public void iriDifferentIri() throws Exception {
        RDFDataset.IRI iri = new RDFDataset.IRI("http://example.com/");
        RDFDataset.IRI other = new RDFDataset.IRI("http://example.com/other");
        Assert.assertNotEquals((Object)iri, (Object)other);
        Assert.assertNotEquals((long)0L, (long)iri.compareTo((RDFDataset.Node)other));
    }

    @Test
    public void iriSameIri() throws Exception {
        RDFDataset.IRI iri = new RDFDataset.IRI("http://example.com/same");
        RDFDataset.IRI same = new RDFDataset.IRI("http://example.com/same");
        Assert.assertEquals((Object)iri, (Object)same);
        Assert.assertEquals((long)0L, (long)iri.compareTo((RDFDataset.Node)same));
    }

    @Test
    public void iriDifferentBlankNode() throws Exception {
        RDFDataset.IRI iri = new RDFDataset.IRI("b1");
        RDFDataset.BlankNode bnode = new RDFDataset.BlankNode("b1");
        Assert.assertNotEquals((Object)iri, (Object)bnode);
        Assert.assertNotEquals((Object)bnode, (Object)iri);
        Assert.assertNotEquals((long)0L, (long)iri.compareTo((RDFDataset.Node)bnode));
        Assert.assertNotEquals((long)0L, (long)bnode.compareTo((RDFDataset.Node)iri));
    }

    @Test
    public void literalDifferentBlankNode() throws Exception {
        RDFDataset.Literal literal = new RDFDataset.Literal("b1", null, null);
        RDFDataset.BlankNode bnode = new RDFDataset.BlankNode("b1");
        Assert.assertNotEquals((Object)literal, (Object)bnode);
        Assert.assertNotEquals((Object)bnode, (Object)literal);
        Assert.assertNotEquals((long)0L, (long)literal.compareTo((RDFDataset.Node)bnode));
        Assert.assertNotEquals((long)0L, (long)bnode.compareTo((RDFDataset.Node)literal));
    }
}

