/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ContextCompactionTest {
    @Test
    public void testCompaction() throws Exception {
        HashMap<String, String> contextAbbrevs = new HashMap<String, String>();
        contextAbbrevs.put("so", "http://schema.org/");
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("@context", contextAbbrevs);
        json.put("@id", "http://example.org/my_work");
        LinkedList<String> types = new LinkedList<String>();
        types.add("so:CreativeWork");
        json.put("@type", types);
        json.put("so:name", "My Work");
        json.put("so:url", "http://example.org/my_work");
        JsonLdOptions options = new JsonLdOptions();
        options.setBase("http://schema.org/");
        options.setCompactArrays(Boolean.valueOf(true));
        LinkedList<String> newContexts = new LinkedList<String>();
        newContexts.add("http://schema.org/");
        Map compacted = JsonLdProcessor.compact(json, newContexts, (JsonLdOptions)options);
        Assert.assertTrue((String)"Compaction removed the context", (boolean)compacted.containsKey("@context"));
        Assert.assertFalse((String)"Compaction of context should be a string, not a list", (boolean)(compacted.get("@context") instanceof List));
    }
}

