/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JsonLdFramingTest {
    @Test
    public void testFrame0001() throws IOException, JsonLdError {
        Object frame = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0001-frame.jsonld"));
        Object in = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0001-in.jsonld"));
        Map frame2 = JsonLdProcessor.frame((Object)in, (Object)frame, (JsonLdOptions)new JsonLdOptions());
        Assert.assertEquals((long)2L, (long)frame2.size());
    }

    @Test
    public void testFrame0002() throws IOException, JsonLdError {
        Object frame = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0002-frame.jsonld"));
        Object in = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0002-in.jsonld"));
        JsonLdOptions opts = new JsonLdOptions();
        opts.setCompactArrays(Boolean.valueOf(false));
        Map frame2 = JsonLdProcessor.frame((Object)in, (Object)frame, (JsonLdOptions)opts);
        Object out = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0002-out.jsonld"));
        Assert.assertEquals((Object)out, (Object)frame2);
    }

    @Test
    public void testFrame0004() throws IOException, JsonLdError {
        Object frame = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0004-frame.jsonld"));
        Object in = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0004-in.jsonld"));
        JsonLdOptions opts = new JsonLdOptions();
        opts.setCompactArrays(Boolean.valueOf(true));
        Map frame2 = JsonLdProcessor.frame((Object)in, (Object)frame, (JsonLdOptions)opts);
        Object out = JsonUtils.fromInputStream((InputStream)this.getClass().getResourceAsStream("/custom/frame-0004-out.jsonld"));
        Assert.assertEquals((Object)out, (Object)frame2);
    }
}

