/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JsonLdPerformanceTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private File testDir;

    @Before
    public void setUp() throws Exception {
        this.testDir = this.tempDir.newFolder("jsonld-perf-tests-");
    }

    @Ignore(value="Enable as necessary for manual testing, particularly to test that it fails due to irregular URIs")
    @Test
    public final void testPerformance1() throws Exception {
        this.testCompaction("Long", new GZIPInputStream(new FileInputStream(new File("/home/peter/Downloads/2000007922.jsonld.gz"))));
    }

    @Ignore(value="Enable as necessary to test performance")
    @Test
    public final void testLaxMergeValuesPerfFast() throws Exception {
        this.testCompaction("Fast", new FileInputStream(new File("/home/peter/Downloads/jsonldperfs/fast.jsonld")));
    }

    @Ignore(value="Enable as necessary to test performance")
    @Test
    public final void testLaxMergeValuesPerfSlow() throws Exception {
        this.testCompaction("Slow", new FileInputStream(new File("/home/peter/Downloads/jsonldperfs/slow.jsonld")));
    }

    private void testCompaction(String label, InputStream nextInputStream) throws IOException, JsonLdError {
        File testFile = File.createTempFile("jsonld-perf-source-", ".jsonld", this.testDir);
        FileUtils.copyInputStreamToFile((InputStream)nextInputStream, (File)testFile);
        LongSummaryStatistics parseStats = new LongSummaryStatistics();
        LongSummaryStatistics compactStats = new LongSummaryStatistics();
        for (int i = 0; i < 1000; ++i) {
            try (BufferedInputStream testInput = new BufferedInputStream(new FileInputStream(testFile));){
                long parseStart = System.currentTimeMillis();
                Object inputObject = JsonUtils.fromInputStream((InputStream)testInput);
                parseStats.accept(System.currentTimeMillis() - parseStart);
                JsonLdOptions opts = new JsonLdOptions("urn:test:");
                long compactStart = System.currentTimeMillis();
                JsonLdProcessor.compact((Object)inputObject, null, (JsonLdOptions)opts);
                compactStats.accept(System.currentTimeMillis() - compactStart);
                continue;
            }
        }
        System.out.println("(" + label + ") Parse average : " + parseStats.getAverage());
        System.out.println("(" + label + ") Compact average : " + compactStats.getAverage());
    }

    @Ignore(value="Disable performance tests by default")
    @Test
    public final void testPerformanceRandom() throws Exception {
        int i;
        Random prng = new Random();
        int rounds = 10000;
        String exNs = "http://example.org/";
        String bnode = "_:anon";
        String uri1 = "http://example.org/a1";
        String uri2 = "http://example.org/b2";
        String uri3 = "http://example.org/c3";
        ArrayList<String> potentialSubjects = new ArrayList<String>();
        potentialSubjects.add("_:anon");
        potentialSubjects.add("http://example.org/a1");
        potentialSubjects.add("http://example.org/b2");
        potentialSubjects.add("http://example.org/c3");
        for (i = 0; i < 50; ++i) {
            potentialSubjects.add("_:" + i);
        }
        for (i = 1; i < 50; ++i) {
            potentialSubjects.add("_:a" + Integer.toHexString(i).toUpperCase());
        }
        for (i = 0; i < 200; ++i) {
            potentialSubjects.add("http://example.org/" + Integer.toHexString(i) + "/z" + Integer.toOctalString(i % 20));
        }
        Collections.shuffle(potentialSubjects, prng);
        ArrayList<String> potentialObjects = new ArrayList<String>();
        potentialObjects.addAll(potentialSubjects);
        Collections.shuffle(potentialObjects, prng);
        ArrayList<String> potentialPredicates = new ArrayList<String>();
        potentialPredicates.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        potentialPredicates.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#List");
        potentialPredicates.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        potentialPredicates.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        potentialPredicates.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#object");
        potentialPredicates.add("http://www.w3.org/2001/XMLSchema#string");
        Collections.shuffle(potentialPredicates, prng);
        RDFDataset testData = new RDFDataset();
        for (int i2 = 0; i2 < 2000; ++i2) {
            String nextObject = (String)potentialObjects.get(prng.nextInt(potentialObjects.size()));
            boolean isLiteral = true;
            if (nextObject.startsWith("_:") || nextObject.startsWith("http://")) {
                isLiteral = false;
            }
            if (isLiteral) {
                if (i2 % 2 == 0) {
                    testData.addQuad((String)potentialSubjects.get(prng.nextInt(potentialSubjects.size())), (String)potentialPredicates.get(prng.nextInt(potentialPredicates.size())), nextObject, "http://www.w3.org/2001/XMLSchema#string", (String)potentialSubjects.get(prng.nextInt(potentialSubjects.size())), null);
                    continue;
                }
                if (i2 % 5 != 0) continue;
                testData.addTriple((String)potentialSubjects.get(prng.nextInt(potentialSubjects.size())), (String)potentialPredicates.get(prng.nextInt(potentialPredicates.size())), nextObject, "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "en");
                continue;
            }
            if (i2 % 2 == 0) {
                testData.addQuad((String)potentialSubjects.get(prng.nextInt(potentialSubjects.size())), (String)potentialPredicates.get(prng.nextInt(potentialPredicates.size())), nextObject, (String)potentialSubjects.get(prng.nextInt(potentialSubjects.size())));
                continue;
            }
            if (i2 % 5 != 0) continue;
            testData.addTriple((String)potentialSubjects.get(prng.nextInt(potentialSubjects.size())), (String)potentialPredicates.get(prng.nextInt(potentialPredicates.size())), nextObject);
        }
        System.out.println("RDF triples to JSON-LD (internal objects, not parsed from a document)...");
        JsonLdOptions options = new JsonLdOptions();
        JsonLdApi jsonLdApi = new JsonLdApi(options);
        int[] hashCodes = new int[10000];
        LongSummaryStatistics statsFirst5000 = new LongSummaryStatistics();
        LongSummaryStatistics stats = new LongSummaryStatistics();
        for (int i3 = 0; i3 < 10000; ++i3) {
            long start = System.nanoTime();
            List fromRDF = jsonLdApi.fromRDF(testData);
            if (i3 < 5000) {
                statsFirst5000.accept(System.nanoTime() - start);
            } else {
                stats.accept(System.nanoTime() - start);
            }
            hashCodes[i3] = ((Object)fromRDF).hashCode();
            fromRDF = null;
        }
        System.out.println("First 5000 out of 10000");
        System.out.println("Average: " + statsFirst5000.getAverage() / 100000.0);
        System.out.println("Sum: " + statsFirst5000.getSum() / 100000L);
        System.out.println("Maximum: " + statsFirst5000.getMax() / 100000L);
        System.out.println("Minimum: " + statsFirst5000.getMin() / 100000L);
        System.out.println("Count: " + statsFirst5000.getCount());
        System.out.println("Post 5000 out of 10000");
        System.out.println("Average: " + stats.getAverage() / 100000.0);
        System.out.println("Sum: " + stats.getSum() / 100000L);
        System.out.println("Maximum: " + stats.getMax() / 100000L);
        System.out.println("Minimum: " + stats.getMin() / 100000L);
        System.out.println("Count: " + stats.getCount());
        System.out.println("RDF triples to JSON-LD (internal objects, not parsed from a document), using laxMergeValue...");
        JsonLdOptions optionsLax = new JsonLdOptions();
        JsonLdApi jsonLdApiLax = new JsonLdApi(optionsLax);
        int[] hashCodesLax = new int[10000];
        LongSummaryStatistics statsLaxFirst5000 = new LongSummaryStatistics();
        LongSummaryStatistics statsLax = new LongSummaryStatistics();
        for (int i4 = 0; i4 < 10000; ++i4) {
            long start = System.nanoTime();
            List fromRDF = jsonLdApiLax.fromRDF(testData, true);
            if (i4 < 5000) {
                statsLaxFirst5000.accept(System.nanoTime() - start);
            } else {
                statsLax.accept(System.nanoTime() - start);
            }
            hashCodesLax[i4] = ((Object)fromRDF).hashCode();
            fromRDF = null;
        }
        System.out.println("First 5000 out of 10000");
        System.out.println("Average: " + statsLaxFirst5000.getAverage() / 100000.0);
        System.out.println("Sum: " + statsLaxFirst5000.getSum() / 100000L);
        System.out.println("Maximum: " + statsLaxFirst5000.getMax() / 100000L);
        System.out.println("Minimum: " + statsLaxFirst5000.getMin() / 100000L);
        System.out.println("Count: " + statsLaxFirst5000.getCount());
        System.out.println("Post 5000 out of 10000");
        System.out.println("Average: " + statsLax.getAverage() / 100000.0);
        System.out.println("Sum: " + statsLax.getSum() / 100000L);
        System.out.println("Maximum: " + statsLax.getMax() / 100000L);
        System.out.println("Minimum: " + statsLax.getMin() / 100000L);
        System.out.println("Count: " + statsLax.getCount());
        System.out.println("Non-pretty print benchmarking...");
        JsonLdOptions options2 = new JsonLdOptions();
        JsonLdApi jsonLdApi2 = new JsonLdApi(options2);
        LongSummaryStatistics statsFirst5000Part2 = new LongSummaryStatistics();
        LongSummaryStatistics statsPart2 = new LongSummaryStatistics();
        List fromRDF2 = jsonLdApi2.fromRDF(testData);
        for (int i5 = 0; i5 < 10000; ++i5) {
            long start = System.nanoTime();
            JsonUtils.toString((Object)fromRDF2);
            if (i5 < 5000) {
                statsFirst5000Part2.accept(System.nanoTime() - start);
                continue;
            }
            statsPart2.accept(System.nanoTime() - start);
        }
        System.out.println("First 5000 out of 10000");
        System.out.println("Average: " + statsFirst5000Part2.getAverage() / 100000.0);
        System.out.println("Sum: " + statsFirst5000Part2.getSum() / 100000L);
        System.out.println("Maximum: " + statsFirst5000Part2.getMax() / 100000L);
        System.out.println("Minimum: " + statsFirst5000Part2.getMin() / 100000L);
        System.out.println("Count: " + statsFirst5000Part2.getCount());
        System.out.println("Post 5000 out of 10000");
        System.out.println("Average: " + statsPart2.getAverage() / 100000.0);
        System.out.println("Sum: " + statsPart2.getSum() / 100000L);
        System.out.println("Maximum: " + statsPart2.getMax() / 100000L);
        System.out.println("Minimum: " + statsPart2.getMin() / 100000L);
        System.out.println("Count: " + statsPart2.getCount());
        System.out.println("Pretty print benchmarking...");
        JsonLdOptions options3 = new JsonLdOptions();
        JsonLdApi jsonLdApi3 = new JsonLdApi(options3);
        LongSummaryStatistics statsFirst5000Part3 = new LongSummaryStatistics();
        LongSummaryStatistics statsPart3 = new LongSummaryStatistics();
        List fromRDF3 = jsonLdApi3.fromRDF(testData);
        for (int i6 = 0; i6 < 10000; ++i6) {
            long start = System.nanoTime();
            JsonUtils.toPrettyString((Object)fromRDF3);
            if (i6 < 5000) {
                statsFirst5000Part3.accept(System.nanoTime() - start);
                continue;
            }
            statsPart3.accept(System.nanoTime() - start);
        }
        System.out.println("First 5000 out of 10000");
        System.out.println("Average: " + statsFirst5000Part3.getAverage() / 100000.0);
        System.out.println("Sum: " + statsFirst5000Part3.getSum() / 100000L);
        System.out.println("Maximum: " + statsFirst5000Part3.getMax() / 100000L);
        System.out.println("Minimum: " + statsFirst5000Part3.getMin() / 100000L);
        System.out.println("Count: " + statsFirst5000Part3.getCount());
        System.out.println("Post 5000 out of 10000");
        System.out.println("Average: " + statsPart3.getAverage() / 100000.0);
        System.out.println("Sum: " + statsPart3.getSum() / 100000L);
        System.out.println("Maximum: " + statsPart3.getMax() / 100000L);
        System.out.println("Minimum: " + statsPart3.getMin() / 100000L);
        System.out.println("Count: " + statsPart3.getCount());
        System.out.println("Expansion benchmarking...");
        JsonLdOptions options4 = new JsonLdOptions();
        JsonLdApi jsonLdApi4 = new JsonLdApi(options4);
        LongSummaryStatistics statsFirst5000Part4 = new LongSummaryStatistics();
        LongSummaryStatistics statsPart4 = new LongSummaryStatistics();
        List fromRDF4 = jsonLdApi4.fromRDF(testData);
        for (int i7 = 0; i7 < 10000; ++i7) {
            long start = System.nanoTime();
            JsonLdProcessor.expand((Object)fromRDF4, (JsonLdOptions)options4);
            if (i7 < 5000) {
                statsFirst5000Part4.accept(System.nanoTime() - start);
                continue;
            }
            statsPart4.accept(System.nanoTime() - start);
        }
        System.out.println("First 5000 out of 10000");
        System.out.println("Average: " + statsFirst5000Part4.getAverage() / 100000.0);
        System.out.println("Sum: " + statsFirst5000Part4.getSum() / 100000L);
        System.out.println("Maximum: " + statsFirst5000Part4.getMax() / 100000L);
        System.out.println("Minimum: " + statsFirst5000Part4.getMin() / 100000L);
        System.out.println("Count: " + statsFirst5000Part4.getCount());
        System.out.println("Post 5000 out of 10000");
        System.out.println("Average: " + statsPart4.getAverage() / 100000.0);
        System.out.println("Sum: " + statsPart4.getSum() / 100000L);
        System.out.println("Maximum: " + statsPart4.getMax() / 100000L);
        System.out.println("Minimum: " + statsPart4.getMin() / 100000L);
        System.out.println("Count: " + statsPart4.getCount());
    }

    @Ignore(value="Disable performance tests by default")
    @Test
    public final void slowVsFast5Predicates() throws Exception {
        String ns = "http://www.example.com/foo/";
        Function<Integer, String> subjectGenerator = index -> "http://www.example.com/foo/s";
        Function<Integer, String> predicateGenerator = index -> "http://www.example.com/foo/p" + Integer.toString(index % 5);
        Function<Integer, String> objectGenerator = index -> "http://www.example.com/foo/o" + Integer.toString(index);
        int tripleCount = 2000;
        int warmingRounds = 200;
        int rounds = 1000;
        this.runLaxVersusSlowToRDFTest("5 predicates", "http://www.example.com/foo/", subjectGenerator, predicateGenerator, objectGenerator, 2000, 200, 1000);
    }

    @Ignore(value="Disable performance tests by default")
    @Test
    public final void slowVsFast2Predicates() throws Exception {
        String ns = "http://www.example.com/foo/";
        Function<Integer, String> subjectGenerator = index -> "http://www.example.com/foo/s";
        Function<Integer, String> predicateGenerator = index -> "http://www.example.com/foo/p" + Integer.toString(index % 2);
        Function<Integer, String> objectGenerator = index -> "http://www.example.com/foo/o" + Integer.toString(index);
        int tripleCount = 2000;
        int warmingRounds = 200;
        int rounds = 1000;
        this.runLaxVersusSlowToRDFTest("2 predicates", "http://www.example.com/foo/", subjectGenerator, predicateGenerator, objectGenerator, 2000, 200, 1000);
    }

    @Ignore(value="Disable performance tests by default")
    @Test
    public final void slowVsFast1Predicate() throws Exception {
        String ns = "http://www.example.com/foo/";
        Function<Integer, String> subjectGenerator = index -> "http://www.example.com/foo/s";
        Function<Integer, String> predicateGenerator = index -> "http://www.example.com/foo/p";
        Function<Integer, String> objectGenerator = index -> "http://www.example.com/foo/o" + Integer.toString(index);
        int tripleCount = 2000;
        int warmingRounds = 200;
        int rounds = 1000;
        this.runLaxVersusSlowToRDFTest("1 predicate", "http://www.example.com/foo/", subjectGenerator, predicateGenerator, objectGenerator, 2000, 200, 1000);
    }

    @Ignore(value="Disable performance tests by default")
    @Test
    public final void slowVsFastMultipleSubjects1Predicate() throws Exception {
        String ns = "http://www.example.com/foo/";
        Function<Integer, String> subjectGenerator = index -> "http://www.example.com/foo/s" + Integer.toString(index % 100);
        Function<Integer, String> predicateGenerator = index -> "http://www.example.com/foo/p";
        Function<Integer, String> objectGenerator = index -> "http://www.example.com/foo/o" + Integer.toString(index);
        int tripleCount = 2000;
        int warmingRounds = 200;
        int rounds = 1000;
        this.runLaxVersusSlowToRDFTest("100 subjects and 1 predicate", "http://www.example.com/foo/", subjectGenerator, predicateGenerator, objectGenerator, 2000, 200, 1000);
    }

    @Ignore(value="Disable performance tests by default")
    @Test
    public final void slowVsFastMultipleSubjects5Predicates() throws Exception {
        String ns = "http://www.example.com/foo/";
        Function<Integer, String> subjectGenerator = index -> "http://www.example.com/foo/s" + Integer.toString(index % 1000);
        Function<Integer, String> predicateGenerator = index -> "http://www.example.com/foo/p" + Integer.toString(index % 5);
        Function<Integer, String> objectGenerator = index -> "http://www.example.com/foo/o" + Integer.toString(index);
        int tripleCount = 2000;
        int warmingRounds = 200;
        int rounds = 1000;
        this.runLaxVersusSlowToRDFTest("1000 subjects and 5 predicates", "http://www.example.com/foo/", subjectGenerator, predicateGenerator, objectGenerator, 2000, 200, 1000);
    }

    private void runLaxVersusSlowToRDFTest(String label, String ns, Function<Integer, String> subjectGenerator, Function<Integer, String> predicateGenerator, Function<Integer, String> objectGenerator, int tripleCount, int warmingRounds, int rounds) throws JsonLdError {
        int i;
        System.out.println("Running test for lax versus slow for " + label);
        RDFDataset inputRdf = new RDFDataset();
        inputRdf.setNamespace("ex", ns);
        for (int i2 = 0; i2 < tripleCount; ++i2) {
            inputRdf.addTriple(subjectGenerator.apply(i2), predicateGenerator.apply(i2), objectGenerator.apply(i2));
        }
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        for (i = 0; i < warmingRounds; ++i) {
            new JsonLdApi(options).fromRDF(inputRdf);
        }
        for (i = 0; i < warmingRounds; ++i) {
            new JsonLdApi(options).fromRDF(inputRdf, true);
        }
        System.out.println("Average time to parse a dataset containing " + tripleCount + " different triples:");
        long startLax = System.currentTimeMillis();
        for (int i3 = 0; i3 < rounds; ++i3) {
            new JsonLdApi(options).fromRDF(inputRdf, true);
        }
        System.out.println("\t- Assuming no duplicates: " + (System.currentTimeMillis() - startLax) / (long)rounds);
        long start = System.currentTimeMillis();
        for (int i4 = 0; i4 < rounds; ++i4) {
            new JsonLdApi(options).fromRDF(inputRdf);
        }
        System.out.println("\t- Assuming duplicates: " + (System.currentTimeMillis() - start) / (long)rounds);
    }

    @Test
    public final void duplicatedTriplesInAnRDFDataset() throws Exception {
        RDFDataset inputRdf = new RDFDataset();
        String ns = "http://www.example.com/foo/";
        inputRdf.setNamespace("ex", "http://www.example.com/foo/");
        inputRdf.addTriple("http://www.example.com/foo/s", "http://www.example.com/foo/p", "http://www.example.com/foo/o");
        inputRdf.addTriple("http://www.example.com/foo/s", "http://www.example.com/foo/p", "http://www.example.com/foo/o");
        for (RDFDataset.Quad quad : inputRdf.getQuads("@default")) {
        }
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        Map fromRDF = JsonLdProcessor.compact((Object)new JsonLdApi(options).fromRDF(inputRdf), (Object)inputRdf.getContext(), (JsonLdOptions)options);
        String jsonld = JsonUtils.toPrettyString((Object)fromRDF);
        fromRDF = JsonLdProcessor.compact((Object)new JsonLdApi(options).fromRDF(inputRdf, true), (Object)inputRdf.getContext(), (JsonLdOptions)options);
        jsonld = JsonUtils.toPrettyString((Object)fromRDF);
    }
}

