/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdApi;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import java.net.URL;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Test;

public class LongestPrefixTest {
    @Test
    public void toRdfWithNamespace() throws Exception {
        URL contextUrl = this.getClass().getResource("/custom/contexttest-0003.jsonld");
        Assert.assertNotNull((Object)contextUrl);
        Object context = JsonUtils.fromURL((URL)contextUrl, (CloseableHttpClient)JsonUtils.getDefaultHttpClient());
        Assert.assertNotNull((Object)context);
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        RDFDataset rdf = (RDFDataset)JsonLdProcessor.toRDF((Object)context, (JsonLdOptions)options);
        Assert.assertEquals((Object)"http://vocab.getty.edu/aat/", (Object)rdf.getNamespace("aat"));
        Assert.assertEquals((Object)"http://vocab.getty.edu/aat/rev/", (Object)rdf.getNamespace("aat_rev"));
    }

    @Test
    public void fromRdfWithNamespaceLexicographicallyShortestChosen() throws Exception {
        RDFDataset inputRdf = new RDFDataset();
        inputRdf.setNamespace("aat", "http://vocab.getty.edu/aat/");
        inputRdf.setNamespace("aat_rev", "http://vocab.getty.edu/aat/rev/");
        inputRdf.addTriple("http://vocab.getty.edu/aat/rev/5001065997", "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://vocab.getty.edu/aat/datatype");
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        Map fromRDF = JsonLdProcessor.compact((Object)new JsonLdApi(options).fromRDF(inputRdf), (Object)inputRdf.getContext(), (JsonLdOptions)options);
        RDFDataset rdf = (RDFDataset)JsonLdProcessor.toRDF((Object)fromRDF, (JsonLdOptions)options);
        Assert.assertEquals((Object)"http://vocab.getty.edu/aat/", (Object)rdf.getNamespace("aat"));
        Assert.assertEquals((Object)"http://vocab.getty.edu/aat/rev/", (Object)rdf.getNamespace("aat_rev"));
        String toJSONLD = JsonUtils.toPrettyString((Object)fromRDF);
        Assert.assertTrue((String)"The lexicographically shortest URI was not chosen", (boolean)toJSONLD.contains("aat:rev/"));
    }

    @Test
    public void fromRdfWithNamespaceLexicographicallyShortestChosen2() throws Exception {
        RDFDataset inputRdf = new RDFDataset();
        inputRdf.setNamespace("aat", "http://vocab.getty.edu/aat/");
        inputRdf.setNamespace("aatrev", "http://vocab.getty.edu/aat/rev/");
        inputRdf.addTriple("http://vocab.getty.edu/aat/rev/5001065997", "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://vocab.getty.edu/aat/datatype");
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        Map fromRDF = JsonLdProcessor.compact((Object)new JsonLdApi(options).fromRDF(inputRdf), (Object)inputRdf.getContext(), (JsonLdOptions)options);
        RDFDataset rdf = (RDFDataset)JsonLdProcessor.toRDF((Object)fromRDF, (JsonLdOptions)options);
        Assert.assertEquals((Object)"http://vocab.getty.edu/aat/", (Object)rdf.getNamespace("aat"));
        Assert.assertEquals((Object)"http://vocab.getty.edu/aat/rev/", (Object)rdf.getNamespace("aatrev"));
        String toJSONLD = JsonUtils.toPrettyString((Object)fromRDF);
        Assert.assertFalse((String)"The lexicographically shortest URI was not chosen", (boolean)toJSONLD.contains("aat:rev/"));
    }

    @Test
    public void prefixUsedToShortenPredicate() throws Exception {
        RDFDataset inputRdf = new RDFDataset();
        inputRdf.setNamespace("ex", "http://www.a.com/foo/");
        inputRdf.addTriple("http://www.a.com/foo/s", "http://www.a.com/foo/p", "http://www.a.com/foo/o");
        Assert.assertEquals((Object)"http://www.a.com/foo/", (Object)inputRdf.getNamespace("ex"));
        JsonLdOptions options = new JsonLdOptions();
        options.useNamespaces = true;
        Map fromRDF = JsonLdProcessor.compact((Object)new JsonLdApi(options).fromRDF(inputRdf), (Object)inputRdf.getContext(), (JsonLdOptions)options);
        String toJSONLD = JsonUtils.toPrettyString((Object)fromRDF);
        Assert.assertFalse((String)"The lexicographically shortest URI was not chosen", (boolean)toJSONLD.contains("http://www.a.com/foo/p"));
    }
}

