/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.utils.JarCacheStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MinimalSchemaOrgRegressionTest {
    private static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";

    @Test
    public void testHttpURLConnection() throws Exception {
        URL url = new URL("http://schema.org/");
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.addRequestProperty("Accept", ACCEPT_HEADER);
        InputStream directStream = urlConn.getInputStream();
        this.verifyInputStream(directStream);
    }

    private void verifyInputStream(InputStream directStream) throws IOException {
        StringWriter output = new StringWriter();
        try {
            IOUtils.copy((InputStream)directStream, (Writer)output, (Charset)Charset.forName("UTF-8"));
        }
        finally {
            directStream.close();
            output.flush();
        }
        String outputString = output.toString();
        Assert.assertTrue((boolean)outputString.endsWith("}\n"));
        Assert.assertTrue((outputString.length() > 100000 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApacheHttpClient() throws Exception {
        URL url = new URL("http://schema.org/");
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        try (CloseableHttpClient httpClient = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setHttpCacheStorage((HttpCacheStorage)new JarCacheStorage(null, cacheConfig, (HttpCacheStorage)new BasicHttpCacheStorage(cacheConfig))).addInterceptorFirst((HttpRequestInterceptor)new RequestAcceptEncoding()).addInterceptorFirst((HttpResponseInterceptor)new ResponseContentEncoding()).setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE).useSystemProperties().build();){
            HttpGet request = new HttpGet(url.toExternalForm());
            request.addHeader("Accept", ACCEPT_HEADER);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);){
                int status = response.getStatusLine().getStatusCode();
                if (status != 200 && status != 203) {
                    throw new IOException("Can't retrieve " + url + ", status code: " + status);
                }
                InputStream content = response.getEntity().getContent();
                this.verifyInputStream(content);
            }
        }
    }
}

