/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.RDFDatasetUtils;
import com.github.jsonldjava.core.Regex;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public class RegexTest {
    @Test
    public void test_TRICKY_UTF_CHARS() throws IOException {
        for (int i = 65536; i <= 983039; ++i) {
            char[] u1 = Character.toChars(i);
            String test = Character.toString(u1[0]) + Character.toString(u1[1]);
            Assert.assertTrue((boolean)test.matches("" + Regex.TRICKY_UTF_CHARS + ""));
        }
    }

    @Test
    public void test_PN_CHARS_BASE() throws IOException {
        String test = "AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff";
        Assert.assertTrue((boolean)"AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff".matches("^(?:" + Regex.PN_CHARS_BASE + ")+$"));
        Assert.assertFalse((boolean)"_".matches("^" + Regex.PN_CHARS_BASE + "$"));
    }

    @Test
    public void test_PN_CHARS_U() {
        String test = "AZa__z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff";
        Assert.assertTrue((boolean)"AZa__z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff".matches("^(?:" + Regex.PN_CHARS_U + ")+$"));
    }

    @Test
    public void test_PN_CHARS() {
        String test = "AZa_-_z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff";
        Assert.assertTrue((boolean)"AZa_-_z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff".matches("^(?:" + Regex.PN_CHARS + ")+$"));
    }

    @Test
    public void test_PN_PREFIX() {
        String testT = "AZa.z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff";
        String testF = "AZa.z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff.";
        Assert.assertTrue((boolean)"AZa.z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff".matches("^" + Regex.PN_PREFIX + "$"));
        Assert.assertFalse((boolean)"AZa.z\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u037f\u1fff\u200c\u200d\u2070\u218f\u2c00\u2fef\u3001\ud7ff\uf900\ufdcf\ufdf0\ufffd\ud800\udc00\udb7f\udfff.".matches("^" + Regex.PN_PREFIX + "$"));
        Assert.assertFalse((boolean)"_:b".matches("^" + Regex.PN_PREFIX + "$"));
    }

    @Test
    public void test_HEX() {
        Assert.assertTrue((boolean)"0123456789ABCDEFabcdef".matches("^" + Regex.HEX + "+$"));
        Assert.assertFalse((boolean)"0123456789ABCDEFabcdefg".matches("^" + Regex.HEX + "+$"));
    }

    @Test
    public void test_PN_LOCAL_ESC() {
        Assert.assertTrue((boolean)"\\&\\!\\_\\~".matches("^(?:" + Regex.PN_LOCAL_ESC + ")+$"));
    }

    @Test
    public void test_PERCENT() {
        Assert.assertTrue((boolean)"%A0".matches("^" + Regex.PERCENT + "$"));
    }

    @Test
    public void test_PLX() {
        Assert.assertTrue((boolean)"%A0".matches("^" + Regex.PLX + "$"));
        Assert.assertTrue((boolean)"\\&\\!\\_\\~%A0".matches("^(?:" + Regex.PLX + ")+$"));
    }

    @Test
    public void test_PN_LOCAL() {
        Assert.assertTrue((boolean)":abcdef.:%FF\\#".matches("^" + Regex.PN_LOCAL + "$"));
    }

    @Test
    public void test_PNAME_NS() {
        Assert.assertTrue((boolean)":".matches("^" + Regex.PNAME_NS + "$"));
        Assert.assertTrue((boolean)"abc:".matches("^" + Regex.PNAME_NS + "$"));
        Assert.assertTrue((boolean)"\u00f8\u02ff\u0370\u037d:".matches("^" + Regex.PNAME_NS + "$"));
    }

    @Test
    public void test_PNAME_LN() {
        Assert.assertTrue((boolean)":p".matches("^" + Regex.PNAME_LN + "$"));
        Assert.assertTrue((boolean)"abc:def".matches("^" + Regex.PNAME_LN + "$"));
        Assert.assertTrue((boolean)"\u00f8\u02ff\u0370\u037d:\u00f8\u02ff\u0370\u037d".matches("^" + Regex.PNAME_LN + "$"));
    }

    @Test
    public void test_UCHAR() {
        Assert.assertTrue((boolean)"\\u0ABC".matches("^" + Regex.UCHAR + "$"));
        Assert.assertTrue((boolean)"\\U0123ABCD".matches("^" + Regex.UCHAR + "$"));
    }

    @Test
    public void test_ECHAR() {
        Assert.assertTrue((boolean)"\\t".matches("^" + Regex.ECHAR + "$"));
        Assert.assertTrue((boolean)"\\\"".matches("^" + Regex.ECHAR + "$"));
        Assert.assertTrue((boolean)"\\\\".matches("^" + Regex.ECHAR + "$"));
    }

    @Test
    public void test_IRIREF() {
        Matcher matcher = Regex.IRIREF.matcher("<http://www.google.com/test#hello>");
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((long)1L, (long)matcher.groupCount());
        Assert.assertNotNull((Object)matcher.group(1));
        Assert.assertEquals((Object)"http://www.google.com/test#hello", (Object)matcher.group(1));
    }

    @Test
    public void test_BLANK_NODE_LABEL() {
        Assert.assertTrue((boolean)"_:abcd".matches("^" + Regex.BLANK_NODE_LABEL + "$"));
        Assert.assertTrue((boolean)"_:abcdz".matches("^" + Regex.BLANK_NODE_LABEL + "$"));
        Assert.assertTrue((boolean)"_:\u00c0AZaz".matches("^" + Regex.BLANK_NODE_LABEL + "$"));
        Assert.assertTrue((boolean)"_:abcd\u00c0".matches("^" + Regex.BLANK_NODE_LABEL + "$"));
        Matcher matcher = Regex.BLANK_NODE_LABEL.matcher("_:\u00f8\u02ff\u0370\u037d");
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((long)1L, (long)matcher.groupCount());
        Assert.assertEquals((Object)"\u00f8\u02ff\u0370\u037d", (Object)matcher.group(1));
    }

    @Test
    public void test_STRING_LITERAL_QUOTE() {
        Matcher matcher = Regex.STRING_LITERAL_QUOTE.matcher("\"IRI with four digit numeric escape (\\\\u)\" ;");
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertTrue((boolean)"\"dffhjkasdhfskldhfoiw'eu\\\"fhowleifh \u00f8\u02ff\u0370\u037d\"".matches("^" + Regex.STRING_LITERAL_QUOTE + "$"));
        Assert.assertFalse((boolean)"\"dffhjkasdhfs\nkldhfoiw\\\"'eufhowleifh \u00f8\u02ff\u0370\u037d\"".matches("^" + Regex.STRING_LITERAL_QUOTE + "$"));
    }

    @Test
    public void test_STRING_LITERAL_SINGLE_QUOTE() {
        Assert.assertTrue((boolean)"'dffhjkasdhfskldhf\\'oiweu\"fhowleifh \u00f8\u02ff\u0370\u037d'".matches("^" + Regex.STRING_LITERAL_SINGLE_QUOTE + "$"));
        Assert.assertFalse((boolean)"\"dffhjkasdhfs\nkldhfoiw\\\"'eufhowleifh \u00f8\u02ff\u0370\u037d\"".matches("^" + Regex.STRING_LITERAL_SINGLE_QUOTE + "$"));
    }

    @Test
    public void test_STRING_LITERAL_LONG_SINGLE_QUOTE() {
        Assert.assertTrue((boolean)"'''dffhjkasdhfsk\nldhfoiw\"'eufhowleifh \u00f8\u02ff\u0370\u037d'''".matches("^" + Regex.STRING_LITERAL_LONG_SINGLE_QUOTE + "$"));
    }

    @Test
    public void test_STRING_LITERAL_LONG_QUOTE() {
        Assert.assertTrue((boolean)"\"\"\"dffhjkasdhfsk\nldhfoiw\"'eufhowleifh \u00f8\u02ff\u0370\u037d\"\"\"".matches("^" + Regex.STRING_LITERAL_LONG_QUOTE + "$"));
    }

    @Test
    public void test_LANGTAG() {
        Assert.assertTrue((boolean)"@en".matches("^" + Regex.LANGTAG + "$"));
        Assert.assertTrue((boolean)"@abc-def".matches("^" + Regex.LANGTAG + "$"));
    }

    @Test
    public void test_unescape() {
        String r = RDFDatasetUtils.unescape((String)"\\u007A");
        Assert.assertTrue((boolean)"z".equals(r));
        r = RDFDatasetUtils.unescape((String)"\\U000F0000");
        Assert.assertTrue((boolean)"\udb80\udc00".equals(r));
        r = RDFDatasetUtils.unescape((String)"\\U00010000");
        Assert.assertTrue((boolean)"\ud800\udc00".equals(r));
        r = RDFDatasetUtils.unescape((String)"\\U00100000");
        Assert.assertTrue((boolean)"\udbc0\udc00".equals(r));
        r = RDFDatasetUtils.unescape((String)"\\t");
        Assert.assertTrue((boolean)"\t".equals(r));
        r = RDFDatasetUtils.unescape((String)"\\t\\u007A\\U000F0000\\U00010000\\n");
        Assert.assertTrue((boolean)"\tz\udb80\udc00\ud800\udc00\n".equals(r));
        r = RDFDatasetUtils.unescape((String)"http://a.example/AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u0384\u1ffe\u200c\u200d\u2070\u2189\u2c00\u2fd5\u3001\ud7fb\ufa0e\ufdc7\ufdf0\uffef");
        Assert.assertTrue((boolean)"http://a.example/AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u0384\u1ffe\u200c\u200d\u2070\u2189\u2c00\u2fd5\u3001\ud7fb\ufa0e\ufdc7\ufdf0\uffef".equals(r));
        r = RDFDatasetUtils.unescape((String)"http://a.example/AZaz\\u00c0\\u00d6\\u00d8\\u00f6\\u00f8\\u02ff\\u0370\\u037d\\u0384\\u1ffe\\u200c\\u200d\\u2070\\u2189\\u2c00\\u2fd5\\u3001\\ud7fb\\ufa0e\\ufdc7\\ufdf0\\uffef\\U00010000\\U000e01ef");
        Assert.assertTrue((boolean)"http://a.example/AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u02ff\u0370\u037d\u0384\u1ffe\u200c\u200d\u2070\u2189\u2c00\u2fd5\u3001\ud7fb\ufa0e\ufdc7\ufdf0\uffef\ud800\udc00\udb40\uddef".equals(r));
    }

    @Test
    public void testDoubleRegex() throws Exception {
        Assert.assertTrue((boolean)Pattern.matches("^([+-])?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)([Ee]([+-])?[0-9]+)?$", "1.1E-1"));
    }
}

