/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonLdUrl;
import com.github.jsonldjava.utils.JsonUtils;
import com.github.jsonldjava.utils.Obj;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EarlTestSuite {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String FILE_SEP = System.getProperty("file.separator");
    private final String cacheDir;
    private String etag;
    private List<Map<String, Object>> tests;

    public EarlTestSuite(String manifestURL) throws IOException {
        this(manifestURL, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EarlTestSuite(String manifestURL, String cacheDir, String etag) throws IOException {
        if (cacheDir == null) {
            cacheDir = EarlTestSuite.getCacheDir(manifestURL);
        }
        this.cacheDir = cacheDir;
        new File(this.cacheDir).mkdirs();
        if (etag == null) {
            URLConnection conn = new URL(manifestURL).openConnection();
            this.etag = conn.getHeaderField("ETag");
        } else {
            this.etag = etag;
        }
        String manifestFile = this.getFile(manifestURL);
        if (manifestURL.endsWith(".ttl") || manifestURL.endsWith("nq") || manifestURL.endsWith("nt")) {
            try {
                Map rval = (Map)JsonLdProcessor.fromRDF((Object)manifestFile, (JsonLdOptions)new JsonLdOptions(manifestURL){
                    {
                        this.format = "text/turtle";
                        this.useNamespaces = true;
                        this.outputForm = "compacted";
                    }
                });
                LinkedHashMap frame = new LinkedHashMap();
                frame.put("@context", rval.get("@context"));
                frame.put("@type", "http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#Manifest");
                rval = JsonLdProcessor.frame((Object)rval, frame, (JsonLdOptions)new JsonLdOptions(manifestURL));
                Map manifest = JsonLdProcessor.compact((Object)rval, frame.get("@context"), (JsonLdOptions)new JsonLdOptions(manifestURL));
                this.tests = (List)Obj.get((Map)manifest, (String[])new String[]{"mf:entries", "@list"});
                return;
            }
            catch (JsonLdError e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!manifestURL.endsWith(".jsonld") && !manifestURL.endsWith(".json")) throw new RuntimeException("unknown manifest file format");
            Object rval = JsonUtils.fromString((String)manifestFile);
            if (!(rval instanceof Map)) throw new RuntimeException("expected JSON manifest file result to be an Object");
            Map manifest = (Map)rval;
            this.tests = (List)Obj.get((Map)manifest, (String[])new String[]{"sequence"});
        }
    }

    private String getFile(String url) throws IOException {
        int read;
        BufferedReader in;
        JsonLdUrl url_ = JsonLdUrl.parse((String)url);
        String fn = this.cacheDir + url_.file + "." + this.etag;
        File f = new File(fn);
        BufferedWriter fw = null;
        if (f.exists()) {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        } else {
            URLConnection conn = new URL(url).openConnection();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            f.createNewFile();
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        }
        StringWriter sw = new StringWriter();
        char[] str = new char[1024];
        while ((read = in.read(str)) >= 0) {
            sw.write(str, 0, read);
            if (fw == null) continue;
            fw.write(str, 0, read);
        }
        in.close();
        if (fw != null) {
            fw.close();
        }
        return sw.toString();
    }

    private static String getCacheDir(String url) {
        JsonLdUrl url_ = JsonLdUrl.parse((String)url);
        String dir = url_.path.substring(0, url_.path.lastIndexOf("/") + 1);
        if (!FILE_SEP.equals("/")) {
            dir = dir.replace("/", FILE_SEP);
        }
        return TEMP_DIR + dir;
    }

    public List<Map<String, Object>> getTests() {
        return this.tests;
    }
}

