/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void fromStringTest() {
        String testString = "{\"seq\":3,\"id\":\"e48dfa735d9fad88db6b7cd696002df7\",\"changes\":[{\"rev\":\"2-6aebf275bc3f29b67695c727d448df8e\"}]}";
        String testFailure = "{{{{{{{{{{{";
        Object obj = null;
        try {
            obj = JsonUtils.fromString((String)"{\"seq\":3,\"id\":\"e48dfa735d9fad88db6b7cd696002df7\",\"changes\":[{\"rev\":\"2-6aebf275bc3f29b67695c727d448df8e\"}]}");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)((Map)obj).containsKey("seq"));
        Assert.assertTrue((boolean)(((Map)obj).get("seq") instanceof Number));
        try {
            obj = JsonUtils.fromString((String)"{{{{{{{{{{{");
            Assert.assertTrue((boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testFromJsonParser() throws Exception {
        ObjectMapper jsonMapper = new ObjectMapper();
        JsonFactory jsonFactory = new JsonFactory((ObjectCodec)jsonMapper);
        StringReader testInputString = new StringReader("{}");
        JsonParser jp = jsonFactory.createParser((Reader)testInputString);
        JsonUtils.fromJsonParser((JsonParser)jp);
    }

    @Test
    public void trailingContent_1() throws IOException {
        this.trailingContent("{}");
    }

    @Test
    public void trailingContent_2() throws IOException {
        this.trailingContent("{}  \t  \r \n  \r\n   ");
    }

    @Test(expected=JsonParseException.class)
    public void trailingContent_3() throws IOException {
        this.trailingContent("{}x");
    }

    @Test(expected=JsonParseException.class)
    public void trailingContent_4() throws IOException {
        this.trailingContent("{}   x");
    }

    @Test(expected=JsonParseException.class)
    public void trailingContent_5() throws IOException {
        this.trailingContent("{} \"x\"");
    }

    @Test(expected=JsonParseException.class)
    public void trailingContent_6() throws IOException {
        this.trailingContent("{} {}");
    }

    @Test(expected=JsonParseException.class)
    public void trailingContent_7() throws IOException {
        this.trailingContent("{},{}");
    }

    @Test(expected=JsonParseException.class)
    public void trailingContent_8() throws IOException {
        this.trailingContent("{},[]");
    }

    private void trailingContent(String string) throws IOException {
        JsonUtils.fromString((String)string);
    }
}

