/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

public class TestUtils {
    public static InputStream copyResourceToFileStream(File testDir, String resource) throws Exception {
        return new FileInputStream(TestUtils.copyResourceToFile(testDir, resource));
    }

    public static String copyResourceToFile(File testDir, String resource) throws Exception {
        String filename = resource;
        String directory = "";
        if (resource.contains("/")) {
            filename = resource.substring(resource.lastIndexOf(47));
            directory = resource.substring(0, resource.lastIndexOf(47));
        }
        File nextDirectory = new File(testDir, directory);
        nextDirectory.mkdirs();
        File nextFile = new File(nextDirectory, filename);
        nextFile.createNewFile();
        InputStream inputStream = TestUtils.class.getResourceAsStream(resource);
        Assert.assertNotNull((String)("Missing test resource: " + resource), (Object)inputStream);
        IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(nextFile));
        return nextFile.getAbsolutePath();
    }

    public static String join(Collection<String> list, String delim) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) break;
            builder.append(delim);
        }
        return builder.toString();
    }

    private TestUtils() {
    }
}

