/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RDFDatasetUtils {
    private static final Pattern UCHAR_MATCHED = Pattern.compile("\\u005C(?:([tbnrf\"'])|(?:u(" + com.github.jsonldjava.core.Regex.HEX + "{4}))|(?:U(" + com.github.jsonldjava.core.Regex.HEX + "{8})))");

    private RDFDatasetUtils() {
    }

    public static String toNQuads(RDFDataset dataset) {
        StringBuilder output = new StringBuilder(256);
        RDFDatasetUtils.toNQuads(dataset, output);
        return output.toString();
    }

    private static void toNQuads(RDFDataset dataset, StringBuilder output) {
        ArrayList<String> quads = new ArrayList<String>();
        for (String graphName : dataset.graphNames()) {
            List<RDFDataset.Quad> triples = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad triple : triples) {
                quads.add(RDFDatasetUtils.toNQuad(triple, graphName));
            }
        }
        Collections.sort(quads);
        for (String quad : quads) {
            output.append(quad);
        }
    }

    static String toNQuad(RDFDataset.Quad triple, String graphName, String bnode) {
        StringBuilder output = new StringBuilder(256);
        RDFDatasetUtils.toNQuad(triple, graphName, bnode, output);
        return output.toString();
    }

    static void toNQuad(RDFDataset.Quad triple, String graphName, String bnode, StringBuilder output) {
        RDFDataset.Node s = triple.getSubject();
        RDFDataset.Node p = triple.getPredicate();
        RDFDataset.Node o = triple.getObject();
        if (s.isIRI()) {
            output.append("<");
            RDFDatasetUtils.escape(s.getValue(), output);
            output.append(">");
        } else if (bnode != null) {
            output.append(bnode.equals(s.getValue()) ? "_:a" : "_:z");
        } else {
            output.append(s.getValue());
        }
        if (p.isIRI()) {
            output.append(" <");
            RDFDatasetUtils.escape(p.getValue(), output);
            output.append("> ");
        } else {
            output.append(" ");
            RDFDatasetUtils.escape(p.getValue(), output);
            output.append(" ");
        }
        if (o.isIRI()) {
            output.append("<");
            RDFDatasetUtils.escape(o.getValue(), output);
            output.append(">");
        } else if (o.isBlankNode()) {
            if (bnode != null) {
                output.append(bnode.equals(o.getValue()) ? "_:a" : "_:z");
            } else {
                output.append(o.getValue());
            }
        } else {
            output.append("\"");
            RDFDatasetUtils.escape(o.getValue(), output);
            output.append("\"");
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString".equals(o.getDatatype())) {
                output.append("@").append(o.getLanguage());
            } else if (!"http://www.w3.org/2001/XMLSchema#string".equals(o.getDatatype())) {
                output.append("^^<");
                RDFDatasetUtils.escape(o.getDatatype(), output);
                output.append(">");
            }
        }
        if (graphName != null) {
            if (graphName.indexOf("_:") != 0) {
                output.append(" <");
                RDFDatasetUtils.escape(graphName, output);
                output.append(">");
            } else if (bnode != null) {
                output.append(" _:g");
            } else {
                output.append(" ").append(graphName);
            }
        }
        output.append(" .\n");
    }

    static String toNQuad(RDFDataset.Quad triple, String graphName) {
        return RDFDatasetUtils.toNQuad(triple, graphName, null);
    }

    static String unescape(String str) {
        String rval = str;
        if (str != null) {
            Matcher m = UCHAR_MATCHED.matcher(str);
            block10: while (m.find()) {
                String uni = m.group(0);
                if (m.group(1) == null) {
                    String hex = m.group(2) != null ? m.group(2) : m.group(3);
                    int v = Integer.parseInt(hex, 16);
                    if (v > 65535) {
                        int vt = v - 65536;
                        int vh = vt >> 10;
                        int v1 = vt & 0x3FF;
                        int w1 = 55296 + vh;
                        int w2 = 56320 + v1;
                        StringBuilder b = new StringBuilder();
                        b.appendCodePoint(w1);
                        b.appendCodePoint(w2);
                        uni = b.toString();
                    } else {
                        uni = Character.toString((char)v);
                    }
                } else {
                    char c = m.group(1).charAt(0);
                    switch (c) {
                        case 'b': {
                            uni = "\b";
                            break;
                        }
                        case 'n': {
                            uni = "\n";
                            break;
                        }
                        case 't': {
                            uni = "\t";
                            break;
                        }
                        case 'f': {
                            uni = "\f";
                            break;
                        }
                        case 'r': {
                            uni = "\r";
                            break;
                        }
                        case '\'': {
                            uni = "'";
                            break;
                        }
                        case '\"': {
                            uni = "\"";
                            break;
                        }
                        case '\\': {
                            uni = "\\";
                            break;
                        }
                        default: {
                            continue block10;
                        }
                    }
                }
                String pat = Pattern.quote(m.group(0));
                String x = Integer.toHexString(uni.charAt(0));
                rval = rval.replaceAll(pat, uni);
            }
        }
        return rval;
    }

    private static void escape(String str, StringBuilder rval) {
        block9: for (int i = 0; i < str.length(); ++i) {
            char hi = str.charAt(i);
            if (hi <= '\b' || hi == '\u000b' || hi == '\f' || hi >= '\u000e' && hi <= '\u001f' || hi >= '\u007f' && hi <= '\u00a0' || hi >= '\u024f' && !Character.isHighSurrogate(hi)) {
                rval.append(String.format("\\u%04x", hi));
                continue;
            }
            if (Character.isHighSurrogate(hi)) {
                char lo = str.charAt(++i);
                int c = (hi << 10) + lo + -56613888;
                rval.append(String.format("\\U%08x", c));
                continue;
            }
            switch (hi) {
                case '\b': {
                    rval.append("\\b");
                    continue block9;
                }
                case '\n': {
                    rval.append("\\n");
                    continue block9;
                }
                case '\t': {
                    rval.append("\\t");
                    continue block9;
                }
                case '\f': {
                    rval.append("\\f");
                    continue block9;
                }
                case '\r': {
                    rval.append("\\r");
                    continue block9;
                }
                case '\"': {
                    rval.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    rval.append("\\\\");
                    continue block9;
                }
                default: {
                    rval.append(hi);
                }
            }
        }
    }

    public static RDFDataset parseNQuads(String input) throws JsonLdError {
        RDFDataset dataset = new RDFDataset();
        String[] lines = Regex.EOLN.split(input);
        int lineNumber = 0;
        for (String line : lines) {
            RDFDataset.Node object;
            ++lineNumber;
            if (Regex.EMPTY.matcher(line).matches()) continue;
            Matcher match = Regex.QUAD.matcher(line);
            if (!match.matches()) {
                throw new JsonLdError(JsonLdError.Error.SYNTAX_ERROR, "Error while parsing N-Quads; invalid quad. line:" + lineNumber);
            }
            RDFDataset.Node subject = match.group(1) != null ? new RDFDataset.IRI(RDFDatasetUtils.unescape(match.group(1))) : new RDFDataset.BlankNode(RDFDatasetUtils.unescape(match.group(2)));
            RDFDataset.IRI predicate = new RDFDataset.IRI(RDFDatasetUtils.unescape(match.group(3)));
            if (match.group(4) != null) {
                object = new RDFDataset.IRI(RDFDatasetUtils.unescape(match.group(4)));
            } else if (match.group(5) != null) {
                object = new RDFDataset.BlankNode(RDFDatasetUtils.unescape(match.group(5)));
            } else {
                String language = RDFDatasetUtils.unescape(match.group(8));
                String datatype = match.group(7) != null ? RDFDatasetUtils.unescape(match.group(7)) : (match.group(8) != null ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString" : "http://www.w3.org/2001/XMLSchema#string");
                String unescaped = RDFDatasetUtils.unescape(match.group(6));
                object = new RDFDataset.Literal(unescaped, datatype, language);
            }
            String name = "@default";
            if (match.group(9) != null) {
                name = RDFDatasetUtils.unescape(match.group(9));
            } else if (match.group(10) != null) {
                name = RDFDatasetUtils.unescape(match.group(10));
            }
            RDFDataset.Quad triple = new RDFDataset.Quad(subject, predicate, object, name);
            if (!dataset.containsKey(name)) {
                ArrayList<RDFDataset.Quad> tmp = new ArrayList<RDFDataset.Quad>();
                tmp.add(triple);
                dataset.put(name, tmp);
                continue;
            }
            List triples = (List)dataset.get(name);
            if (triples.contains(triple)) continue;
            triples.add(triple);
        }
        return dataset;
    }

    private static class Regex {
        public static final Pattern IRI = Pattern.compile("(?:<([^>]*)>)");
        static final Pattern BNODE = Pattern.compile("(_:(?:[A-Za-z][A-Za-z0-9]*))");
        static final Pattern PLAIN = Pattern.compile("\"([^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"");
        static final Pattern DATATYPE = Pattern.compile("(?:\\^\\^" + IRI + ")");
        static final Pattern LANGUAGE = Pattern.compile("(?:@([a-z]+(?:-[a-zA-Z0-9]+)*))");
        static final Pattern LITERAL = Pattern.compile("(?:" + PLAIN + "(?:" + DATATYPE + "|" + LANGUAGE + ")?)");
        static final Pattern WS = Pattern.compile("[ \\t]+");
        static final Pattern WSO = Pattern.compile("[ \\t]*");
        static final Pattern EOLN = Pattern.compile("(?:\r\n)|(?:\n)|(?:\r)");
        static final Pattern EMPTY = Pattern.compile("^" + WSO + "$");
        static final Pattern SUBJECT = Pattern.compile("(?:" + IRI + "|" + BNODE + ")" + WS);
        static final Pattern PROPERTY = Pattern.compile(IRI.pattern() + WS.pattern());
        static final Pattern OBJECT = Pattern.compile("(?:" + IRI + "|" + BNODE + "|" + LITERAL + ")" + WSO);
        static final Pattern GRAPH = Pattern.compile("(?:\\.|(?:(?:" + IRI + "|" + BNODE + ")" + WSO + "\\.))");
        static final Pattern QUAD = Pattern.compile("^" + WSO + SUBJECT + PROPERTY + OBJECT + GRAPH + WSO + "$");

        private Regex() {
        }
    }
}

