/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.ldpclient;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.jena.JenaIRI;
import org.apache.commons.rdf.jena.JenaRDF;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.trellisldp.vocabulary.ACL;
import org.trellisldp.vocabulary.RDF;

public class ACLStatement {
    private static final JenaRDF rdf = new JenaRDF();
    private final Set<IRI> modes;
    private final IRI agent;
    private final IRI accessTo;
    private Graph graph = rdf.createGraph();

    public ACLStatement(Set<IRI> modes, IRI agent, IRI accessTo) {
        this.modes = modes;
        this.agent = agent;
        this.accessTo = accessTo;
    }

    public ByteArrayOutputStream getACL() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamRDF stream = StreamRDFWriter.getWriterStream((OutputStream)out, (RDFFormat)RDFFormat.NTRIPLES);
        JenaIRI auth = rdf.createIRI(this.accessTo.getIRIString() + "?ext=acl#auth");
        this.graph.add((BlankNodeOrIRI)auth, RDF.type, (RDFTerm)ACL.Authorization);
        this.graph.add((BlankNodeOrIRI)auth, ACL.agent, (RDFTerm)this.agent);
        this.graph.add((BlankNodeOrIRI)auth, ACL.accessTo, (RDFTerm)this.accessTo);
        this.modes.forEach(arg_0 -> this.lambda$getACL$0((IRI)auth, arg_0));
        stream.start();
        this.graph.stream().map(arg_0 -> ((JenaRDF)rdf).asJenaTriple(arg_0)).forEachOrdered(arg_0 -> ((StreamRDF)stream).triple(arg_0));
        stream.finish();
        return out;
    }

    private /* synthetic */ void lambda$getACL$0(IRI auth, IRI m) {
        this.graph.add((BlankNodeOrIRI)auth, ACL.mode, (RDFTerm)m);
    }
}

