/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.ldpclient;

import cool.pandora.ldpclient.LdpClient;
import cool.pandora.ldpclient.LdpClientException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;
import org.apache.commons.rdf.api.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trellisldp.vocabulary.DC;
import org.trellisldp.vocabulary.LDP;
import org.trellisldp.vocabulary.Trellis;

public class LdpClientImpl
implements LdpClient {
    private static final Logger log = LoggerFactory.getLogger(LdpClientImpl.class);
    private static final String NON_NULL_IDENTIFIER = "Identifier may not be null!";
    private static HttpClient client = null;

    private LdpClientImpl(HttpClient client) {
        Objects.requireNonNull(client, "HTTP client may not be null!");
        LdpClientImpl.client = client;
    }

    public LdpClientImpl() {
        this(LdpClientImpl.getClient());
    }

    public LdpClientImpl(SSLContext sslContext) {
        this(LdpClientImpl.getH2Client(sslContext));
    }

    static HttpClient getClient() {
        ExecutorService exec = Executors.newCachedThreadPool();
        return HttpClient.newBuilder().executor((Executor)exec).build();
    }

    static HttpClient getH2Client(SSLContext sslContext) {
        ExecutorService exec = Executors.newCachedThreadPool();
        return HttpClient.newBuilder().executor((Executor)exec).sslContext(sslContext).version(HttpClient.Version.HTTP_2).build();
    }

    static String buildLDFQuery(String subject, String predicate, String object) {
        Object sq = "";
        Object pq = "";
        Object oq = "";
        if (Objects.nonNull(subject)) {
            sq = "subject=" + subject;
        }
        if (Objects.nonNull(predicate) && Objects.nonNull(subject)) {
            pq = "&predicate=" + predicate;
        } else if (Objects.nonNull(predicate)) {
            pq = "predicate=" + predicate;
        }
        if (Objects.nonNull(predicate) && Objects.nonNull(object) || Objects.nonNull(subject) && Objects.nonNull(object)) {
            oq = "&object=" + object;
        } else if (Objects.nonNull(object)) {
            oq = "object=" + object;
        }
        return "?" + (String)sq + (String)pq + (String)oq;
    }

    private synchronized String[] buildHeaderEntryList(Map<String, String> metadata) {
        List h = Collections.synchronizedList(new ArrayList());
        metadata.forEach((key, value) -> {
            h.add(key);
            h.add(value);
        });
        return h.toArray(new String[h.size()]);
    }

    @Override
    public Map<String, List<String>> head(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).method("HEAD", HttpRequest.BodyPublisher.noBody()).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " HEAD request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return response.headers().map();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getJson(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Accept", "application/ld+json"};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getDefaultType(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getWithContentType(IRI identifier, String contentType) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Accept", contentType}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Map<String, List<String>> getAcceptDatetime(IRI identifier, String timestamp) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String datetime = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(Long.parseLong(timestamp)));
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Accept-Datetime", datetime}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return response.headers().map();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getTimeMapLinkDefaultFormat(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString() + "?ext=timemap");
            HttpRequest req = HttpRequest.newBuilder((URI)uri).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getTimeMapJsonProfile(IRI identifier, String profile) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString() + "?ext=timemap");
            String[] headers = new String[]{"Accept", "application/ld+json; profile=\"" + profile + "\""};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)(identifier.getIRIString() + "?ext=timemap"), (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getVersionJson(IRI identifier, String profile, String timestamp) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString() + "?version=" + timestamp);
            String[] headers = new String[]{"Accept", "application/ld+json; profile=\"" + profile + "\""};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)(identifier.getIRIString() + "?version=" + timestamp), (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Path getBinary(IRI identifier, Path file) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asFile((Path)file));
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return (Path)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public byte[] getBinary(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asByteArray());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + new String((byte[])response.body(), StandardCharsets.UTF_8));
            return (byte[])response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getBinaryDigest(IRI identifier, String algorithm) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Want-Digest", algorithm}).method("HEAD", HttpRequest.BodyPublisher.noBody()).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            List res = response.headers().map().entrySet().stream().filter(h -> ((String)h.getKey()).equals("digest")).map(Map.Entry::getValue).collect(Collectors.toList());
            return res.stream().flatMap(Collection::stream).collect(Collectors.toList()).stream().findAny().orElse("");
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Path getBinaryVersion(IRI identifier, Path file, String timestamp) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString() + "?version=" + timestamp);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asFile((Path)file));
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)(identifier + "?version=" + timestamp), (Object)String.valueOf(response.statusCode()));
            return (Path)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public byte[] getBinaryVersion(IRI identifier, String timestamp) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString() + "?version=" + timestamp);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asByteArray());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)(identifier.getIRIString() + "?version=" + timestamp), (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + new String((byte[])response.body(), StandardCharsets.UTF_8));
            return (byte[])response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public byte[] getRange(IRI identifier, String byterange) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Range", byterange}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asByteArray());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier.getIRIString(), (Object)String.valueOf(response.statusCode()));
            return (byte[])response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getPrefer(IRI identifier, String prefer) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Prefer", prefer}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getPreferServerManaged(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Prefer", "return=representation; include=\"" + Trellis.PreferServerManaged.getIRIString() + "\""};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getPreferMinimal(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Prefer", "return=representation; include=\"" + LDP.PreferMinimalContainer.getIRIString() + "\""};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getJsonProfile(IRI identifier, String profile) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Accept", "application/ld+json; profile=\"" + profile + "\""};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getJsonProfileLDF(IRI identifier, String profile, String subject, String predicate, String object) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            String q = LdpClientImpl.buildLDFQuery(subject, predicate, object);
            URI uri = new URI(identifier.getIRIString() + q);
            String[] headers = new String[]{"Accept", "application/ld+json; profile=\"" + profile + "\""};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getJsonLDF(IRI identifier, String subject, String predicate, String object) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            String q = LdpClientImpl.buildLDFQuery(subject, predicate, object);
            URI uri = new URI(identifier.getIRIString() + q);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Accept", "application/ld+json"}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)(identifier + q), (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getAcl(IRI identifier, String contentType) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString() + "?ext=acl");
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Accept", contentType}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)(identifier + "?ext=acl"), (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Map<String, List<String>> getCORS(IRI identifier, IRI origin) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Origin", origin.getIRIString(), "Access-Control-Request-Method", "PUT", "Access-Control-Request-Headers", "Content-Type, Link"};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return response.headers().map();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Map<String, List<String>> getCORSSimple(IRI identifier, IRI origin) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Origin", origin.getIRIString(), "Access-Control-Request-Method", "POST", "Access-Control-Request-Headers", "Accept"};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return response.headers().map();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public String getWithMetadata(IRI identifier, Map<String, String> metadata) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] entries = this.buildHeaderEntryList(metadata);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(entries).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            log.debug("Response Body: " + (String)response.body());
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public byte[] getBytesWithMetadata(IRI identifier, Map<String, String> metadata) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] entries = this.buildHeaderEntryList(metadata);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(entries).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asByteArray());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return (byte[])response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Map<String, Map<String, List<String>>> getResponse(IRI identifier, Map<String, String> metadata) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] entries = this.buildHeaderEntryList(metadata);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(entries).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " GET request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            HashMap<String, Map<String, List<String>>> res = new HashMap<String, Map<String, List<String>>>();
            res.put((String)response.body(), response.headers().map());
            return res;
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public Map<String, List<String>> options(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).method("OPTIONS", HttpRequest.BodyPublisher.noBody()).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " OPTIONS request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
            return response.headers().map();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void post(IRI identifier, InputStream stream, String contentType) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType}).POST(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info("New Resource Location {}", (Object)String.valueOf(response.headers().map().get("Location")));
            log.info(String.valueOf(response.version()) + " POST request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void postWithMetadata(IRI identifier, InputStream stream, Map<String, String> metadata) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] entries = this.buildHeaderEntryList(metadata);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(entries).POST(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info("New Resource Location {}", (Object)String.valueOf(response.headers().map().get("Location")));
            log.info(String.valueOf(response.version()) + " POST request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void postWithAuth(IRI identifier, InputStream stream, String contentType, String authorization) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Content-Type", contentType, "Authorization", authorization};
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).POST(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info("New Resource Location {}", (Object)String.valueOf(response.headers().map().get("Location")));
            log.info(String.valueOf(response.version()) + " AUTHORIZED POST request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void postSlug(IRI identifier, String slug, InputStream stream, String contentType) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType, "Slug", slug}).POST(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info("New Resource Location {}", (Object)String.valueOf(response.headers().map().get("Location")));
            log.info(String.valueOf(response.version()) + " POST request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void postBinaryWithDigest(IRI identifier, InputStream stream, String contentType, String digest) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType, "Digest", digest}).POST(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info("New Resource Location {}", (Object)String.valueOf(response.headers().map().get("Location")));
            log.info(String.valueOf(response.version()) + " POST request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void newLdpDc(IRI identifier, String slug, IRI membershipObj) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Content-Type", "text/turtle", "Slug", slug, "Link", LDP.DirectContainer + "; rel=\"type\""};
            String entity = "<> " + LDP.hasMemberRelation + " " + DC.isPartOf + " ;\n" + LDP.membershipResource + " " + membershipObj;
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).POST(HttpRequest.BodyPublisher.fromString((String)entity)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " POST create LDP-DC request to {} returned {}", (Object)uri, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void newLdpDcWithAuth(IRI identifier, String slug, IRI membershipObj, String authorization) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] headers = new String[]{"Content-Type", "text/turtle", "Slug", slug, "Link", LDP.DirectContainer + "; rel=\"type\"", "Authorization", authorization};
            String entity = "<> " + LDP.hasMemberRelation + " " + DC.isPartOf + " ;\n" + LDP.membershipResource + " " + membershipObj;
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(headers).POST(HttpRequest.BodyPublisher.fromString((String)entity)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " AUTHORIZED POST create LDP-DC request to {} returned {}", (Object)uri, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void put(IRI identifier, InputStream stream, String contentType) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType}).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " PUT request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void putWithMetadata(IRI identifier, InputStream stream, Map<String, String> metadata) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String[] entries = this.buildHeaderEntryList(metadata);
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(entries).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " PUT request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void putWithAuth(IRI identifier, InputStream stream, String contentType, String authorization) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType, "Authorization", authorization}).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " AUTHORIZED PUT request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void putIfMatch(IRI identifier, InputStream stream, String contentType, String etag) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType, "ETag", etag}).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " PUT request with matching Etag {} to {} returned {}", new Object[]{etag, identifier, String.valueOf(response.statusCode())});
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void putBinaryWithDigest(IRI identifier, InputStream stream, String contentType, String digest) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType, "Digest", digest}).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " PUT request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void putIfUnmodified(IRI identifier, InputStream stream, String contentType, String time) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", contentType, "If-Unmodified-Since", time}).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " PUT request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void delete(IRI identifier) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).DELETE(HttpRequest.BodyPublisher.noBody()).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " DELETE request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void patch(IRI identifier, InputStream stream) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).header("Content-Type", "application/sparql-update").method("PATCH", HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()) + " PATCH request to {} returned {}", (Object)identifier, (Object)String.valueOf(response.statusCode()));
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    @Override
    public void multipartOptions(IRI identifier) {
        Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
    }

    @Override
    public void multipartStart(IRI identifier, InputStream stream) {
        Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
    }

    @Override
    public void multipartGet(IRI identifier, String sessionId) {
        Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
    }

    @Override
    public void multipartPut(IRI identifier, InputStream stream, String sessionId) {
        Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
    }

    @Override
    public void multipartPost(IRI identifier, InputStream stream, String sessionId) {
        Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
    }

    @Override
    public void multipartDelete(IRI identifier, String sessionId) {
        Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
    }

    @Override
    public void asyncPut(IRI identifier, InputStream stream) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", "application/n-triples"}).PUT(HttpRequest.BodyPublisher.fromInputStream(() -> stream)).build();
            CompletableFuture completableFuture = client.sendAsync(req, HttpResponse.BodyHandler.asString());
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    public byte[] getBytesWithQuery(String query, String contentType) throws LdpClientException {
        try {
            HttpRequest req = HttpRequest.newBuilder((URI)new URI(query)).headers(new String[]{"Content-Type", "application/sparql-query", "Accept", contentType}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asByteArray());
            log.info(String.valueOf(response.version()));
            log.info(String.valueOf(response.statusCode()));
            return (byte[])response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    public String getQuery(String query, String contentType) throws LdpClientException {
        try {
            HttpRequest req = HttpRequest.newBuilder((URI)new URI(query)).headers(new String[]{"Content-Type", "application/sparql-query", "Accept", contentType}).GET().build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()));
            log.info(String.valueOf(response.statusCode()));
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    public byte[] asyncGetBytesWithQuery(String query, String contentType) throws LdpClientException {
        try {
            HttpRequest req = HttpRequest.newBuilder().uri(new URI(query)).headers(new String[]{"Content-Type", "application/sparql-query", "Accept", contentType}).GET().build();
            CompletableFuture response = client.sendAsync(req, HttpResponse.BodyHandler.asByteArray());
            log.info(String.valueOf(((HttpResponse)response.get()).version()));
            log.info(String.valueOf(((HttpResponse)response.get()).statusCode()));
            return (byte[])((HttpResponse)response.get()).body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    public String asyncGetQuery(String query, String contentType) throws LdpClientException {
        try {
            HttpRequest req = HttpRequest.newBuilder().uri(new URI(query)).headers(new String[]{"Content-Type", "application/sparql-query", "Accept", contentType}).GET().build();
            CompletableFuture response = client.sendAsync(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(((HttpResponse)response.get()).version()));
            log.info(String.valueOf(((HttpResponse)response.get()).statusCode()));
            return (String)((HttpResponse)response.get()).body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }

    public String syncUpdate(IRI identifier, String query) throws LdpClientException {
        try {
            Objects.requireNonNull(identifier, NON_NULL_IDENTIFIER);
            URI uri = new URI(identifier.getIRIString());
            String formdata = "update=" + query;
            HttpRequest req = HttpRequest.newBuilder((URI)uri).headers(new String[]{"Content-Type", "application/sparql-query"}).POST(HttpRequest.BodyPublisher.fromString((String)formdata)).build();
            HttpResponse response = client.send(req, HttpResponse.BodyHandler.asString());
            log.info(String.valueOf(response.version()));
            log.info(String.valueOf(response.statusCode()));
            return (String)response.body();
        }
        catch (Exception ex) {
            throw new LdpClientException(ex.toString(), ex.getCause());
        }
    }
}

