/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.ldpclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SimpleSSLContext {
    SSLContext ssl;

    public SimpleSSLContext() throws IOException {
        this.init(SimpleSSLContext.class.getResourceAsStream("/keystore/trellis.jks"));
    }

    public SimpleSSLContext(String dir) throws IOException {
        String file = dir + "/testkeys";
        try (FileInputStream fis = new FileInputStream(file);){
            this.init(fis);
        }
    }

    private void init(InputStream i) throws IOException {
        try {
            char[] passphrase = "changeme".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(i, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            this.ssl = SSLContext.getInstance("TLS");
            this.ssl.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public SSLContext get() {
        return this.ssl;
    }
}

