/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.bag.impl;

import cool.pandora.modeller.Profile;
import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.BaggerFetch;
import cool.pandora.modeller.bag.impl.DefaultBagInfo;
import cool.pandora.modeller.model.BagStatus;
import cool.pandora.modeller.model.Status;
import cool.pandora.modeller.profile.BaggerProfileStore;
import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.PreBag;
import gov.loc.repository.bagit.transformer.impl.DefaultCompleter;
import gov.loc.repository.bagit.transformer.impl.HolePuncherImpl;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.Verifier;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import gov.loc.repository.bagit.verify.impl.RequiredBagInfoTxtFieldsVerifier;
import gov.loc.repository.bagit.verify.impl.ValidVerifierImpl;
import gov.loc.repository.bagit.writer.Writer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBag {
    protected static final Logger log = LoggerFactory.getLogger(DefaultBag.class);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long MAX_SIZE = 0x6400000L;
    public static final short NO_MODE = 0;
    public static final short ZIP_MODE = 1;
    private static final short TAR_MODE = 2;
    private static final short TAR_GZ_MODE = 3;
    private static final short TAR_BZ2_MODE = 4;
    public static final String NO_LABEL = "none";
    public static final String ZIP_LABEL = "zip";
    private static final String TAR_LABEL = "tar";
    public static final String GZ_LABEL = "gz";
    private static final String TAR_GZ_LABEL = "tar.gz";
    private static final String TAR_BZ2_LABEL = "tar.bz2";
    private boolean isHoley = false;
    private boolean isSerial = true;
    private boolean isAddKeepFilesToEmptyFolders = false;
    private boolean isBuildTagManifest = true;
    private boolean isBuildPayloadManifest = true;
    private String tagManifestAlgorithm;
    private String payloadManifestAlgorithm;
    private short serialMode = 0;
    private boolean isValidateOnSave = false;
    private boolean isSerialized = false;
    private boolean dirty = false;
    private File rootDir = null;
    private String name = "bag_";
    private long size;
    private long totalSize = 0L;
    private Bag bilBag;
    private DefaultBagInfo bagInfo = null;
    private Verifier bagStrategy;
    private BaggerFetch fetch;
    private Profile profile;
    private String versionString = null;
    private File bagFile = null;
    private boolean hasText = true;
    private String sequenceID = "normal";
    private String hOCRResource;
    private String listServiceURI;

    public DefaultBag() {
        this(null, BagFactory.Version.V0_96.versionString);
    }

    public DefaultBag(File rootDir, String version) {
        this.versionString = version;
        this.init(rootDir);
    }

    private void display(String s) {
        log.info(this.getClass().getName() + ": " + s);
    }

    private void init(File dir) {
        boolean newBag = dir == null;
        DefaultBag.resetStatus();
        this.rootDir = dir;
        this.display("DefaultBag.init file: " + dir + ", version: " + this.versionString);
        BagFactory bagFactory = new BagFactory();
        if (!newBag) {
            this.bilBag = bagFactory.createBag(this.rootDir);
            this.versionString = this.bilBag.getVersion().versionString;
        } else if (this.versionString != null) {
            BagFactory.Version version = BagFactory.Version.valueOfString((String)this.versionString);
            this.bilBag = bagFactory.createBag(version);
        } else {
            this.bilBag = bagFactory.createBag();
        }
        this.initializeBilBag();
        this.bagInfo = new DefaultBagInfo();
        FetchTxt fetchTxt = this.bilBag.getFetchTxt();
        if (fetchTxt != null && !fetchTxt.isEmpty()) {
            String url = DefaultBag.getBaseUrl(fetchTxt);
            if (url != null && !url.isEmpty()) {
                this.isHoley(true);
                BaggerFetch localFetch = this.getFetch();
                localFetch.setBaseURL(url);
                this.fetch = localFetch;
            } else {
                this.isHoley(false);
            }
        }
        this.payloadManifestAlgorithm = Manifest.Algorithm.MD5.bagItAlgorithm;
        this.tagManifestAlgorithm = Manifest.Algorithm.MD5.bagItAlgorithm;
        this.bagInfo.update(this.bilBag.getBagInfoTxt());
        String lcProject = (String)this.bilBag.getBagInfoTxt().get((Object)"Profile Name");
        if (lcProject != null && !lcProject.isEmpty()) {
            log.debug("Getting [{}] profile", (Object)lcProject);
            Profile localProfile = BaggerProfileStore.getInstance().getProfile(lcProject);
            this.setProfile(localProfile, newBag);
        } else {
            this.clearProfile();
        }
    }

    private void initializeBilBag() {
        BagItTxt bagIt;
        BagInfoTxt bagInfoTxt = this.bilBag.getBagInfoTxt();
        if (bagInfoTxt == null) {
            bagInfoTxt = this.bilBag.getBagPartFactory().createBagInfoTxt();
            Set keys = bagInfoTxt.keySet();
            for (String key : keys) {
                bagInfoTxt.remove((Object)key);
            }
            this.bilBag.putBagFile((BagFile)bagInfoTxt);
        }
        if ((bagIt = this.bilBag.getBagItTxt()) == null) {
            bagIt = this.bilBag.getBagPartFactory().createBagItTxt();
            this.bilBag.putBagFile((BagFile)bagIt);
        }
    }

    public void createPreBag(File data) {
        BagFactory bagFactory = new BagFactory();
        PreBag preBag = bagFactory.createPreBag(data);
        this.bilBag = preBag.makeBagInPlace(BagFactory.LATEST, false);
    }

    public void createPreBagAddKeepFilesToEmptyFolders(File data) {
        BagFactory bagFactory = new BagFactory();
        PreBag preBag = bagFactory.createPreBag(data);
        this.bilBag = preBag.makeBagInPlace(BagFactory.LATEST, false, true);
    }

    public File getBagFile() {
        return this.bagFile;
    }

    private void setBagFile(File fname) {
        this.bagFile = fname;
    }

    public String getDataDirectory() {
        return this.bilBag.getBagConstants().getDataDirectory();
    }

    private static void resetStatus() {
        DefaultBag.isComplete(Status.UNKNOWN);
        DefaultBag.isValid(Status.UNKNOWN);
        DefaultBag.isValidMetadata(Status.UNKNOWN);
    }

    public void setVersion(String v) {
        this.versionString = v;
    }

    public String getVersion() {
        return this.versionString;
    }

    public void setName(String name) {
        String[] list = name.split("\\.");
        String split_name = null;
        if (list.length > 0) {
            split_name = list[0];
        }
        this.name = split_name;
    }

    public String getName() {
        return this.name;
    }

    public void hasText(boolean b) {
        this.hasText = b;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public void setSequenceID(String sequenceID) {
        this.sequenceID = sequenceID;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void sethOCRResource(String hOCRResource) {
        this.hOCRResource = hOCRResource;
    }

    public String gethOCRResource() {
        return this.hOCRResource;
    }

    public void setListServiceBaseURI(String listServiceURI) {
        this.listServiceURI = listServiceURI;
    }

    public String getListServiceBaseURI() {
        return this.listServiceURI;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void isHoley(boolean b) {
        this.isHoley = b;
    }

    public boolean isHoley() {
        return this.isHoley;
    }

    public void isSerial(boolean b) {
        this.isSerial = b;
    }

    public boolean isSerial() {
        return this.isSerial;
    }

    public void setSerialMode(short m) {
        this.serialMode = m;
    }

    public short getSerialMode() {
        return this.serialMode;
    }

    private boolean isNoProject() {
        return this.profile.isNoProfile();
    }

    public void isBuildTagManifest(boolean b) {
        this.isBuildTagManifest = b;
    }

    public boolean isBuildTagManifest() {
        return this.isBuildTagManifest;
    }

    public void isBuildPayloadManifest(boolean b) {
        this.isBuildPayloadManifest = b;
    }

    public boolean isBuildPayloadManifest() {
        return this.isBuildPayloadManifest;
    }

    public void setTagManifestAlgorithm(String s) {
        this.tagManifestAlgorithm = s;
    }

    public String getTagManifestAlgorithm() {
        return this.tagManifestAlgorithm;
    }

    public void setPayloadManifestAlgorithm(String s) {
        this.payloadManifestAlgorithm = s;
    }

    public String getPayloadManifestAlgorithm() {
        return this.payloadManifestAlgorithm;
    }

    public void isAddKeepFilesToEmptyFolders(boolean b) {
        this.isAddKeepFilesToEmptyFolders = b;
    }

    public boolean isAddKeepFilesToEmptyFolders() {
        return this.isAddKeepFilesToEmptyFolders;
    }

    public void isValidateOnSave(boolean b) {
        this.isValidateOnSave = b;
    }

    public boolean isValidateOnSave() {
        return this.isValidateOnSave;
    }

    private static void isComplete(Status status) {
        BagStatus.getInstance().getCompletenessStatus().setStatus(status);
    }

    private static void isValid(Status status) {
        BagStatus.getInstance().getValidationStatus().setStatus(status);
    }

    private static void isValidMetadata(Status status) {
        BagStatus.getInstance().getProfileComplianceStatus().setStatus(status);
    }

    private void isSerialized(boolean b) {
        this.isSerialized = b;
    }

    public boolean isSerialized() {
        return this.isSerialized;
    }

    public void updateBagInfo(Map<String, String> map) {
        this.changeToDirty();
        DefaultBag.isValidMetadata(Status.UNKNOWN);
        this.bagInfo.update(map);
    }

    public DefaultBagInfo getInfo() {
        return this.bagInfo;
    }

    public String getBagInfoContent() {
        String bicontent = "";
        if (this.bagInfo != null) {
            bicontent = this.bagInfo.toString();
        }
        return bicontent;
    }

    private static String getBaseUrl(FetchTxt fetchTxt) {
        String httpToken = "http:";
        String delimToken = "bagit";
        String baseUrl = "";
        try {
            FetchTxt.FilenameSizeUrl fsu;
            if (fetchTxt != null && !fetchTxt.isEmpty() && (fsu = (FetchTxt.FilenameSizeUrl)fetchTxt.get(0)) != null) {
                String[] list;
                String url;
                baseUrl = url = fsu.getUrl();
                for (String s : list = url.split("bagit")) {
                    if (!s.trim().startsWith("http:")) continue;
                    baseUrl = s;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed to get base URL", (Throwable)e);
        }
        return baseUrl;
    }

    public void setFetch(BaggerFetch fetch) {
        this.fetch = fetch;
    }

    public BaggerFetch getFetch() {
        if (this.fetch == null) {
            this.fetch = new BaggerFetch();
        }
        return this.fetch;
    }

    public List<String> getFetchPayload() {
        ArrayList<String> list = new ArrayList<String>();
        FetchTxt fetchTxt = this.bilBag.getFetchTxt();
        if (fetchTxt == null) {
            return list;
        }
        for (FetchTxt.FilenameSizeUrl localFetch : fetchTxt) {
            String s = localFetch.getFilename();
            this.display("DefaultBag.getFetchPayload: " + localFetch.toString());
            list.add(s);
        }
        return list;
    }

    public String getDataContent() {
        this.totalSize = 0L;
        StringBuilder dcontent = new StringBuilder();
        dcontent.append(this.getDataDirectory()).append("/");
        dcontent.append('\n');
        Collection files = this.bilBag.getPayload();
        if (files != null) {
            for (BagFile file : files) {
                try {
                    if (file == null) continue;
                    this.totalSize += file.getSize();
                    dcontent.append(file.getFilepath());
                    dcontent.append('\n');
                }
                catch (Exception e) {
                    log.error("Failed to get data content", (Throwable)e);
                }
            }
        }
        this.setSize(this.totalSize);
        return dcontent.toString();
    }

    public long getDataSize() {
        return this.totalSize;
    }

    public int getDataNumber() {
        return this.bilBag.getPayload().size();
    }

    private void clearProfile() {
        Profile noProfile = new Profile();
        noProfile.setName("<no profile>");
        noProfile.setIsDefault();
        this.setProfile(noProfile, false);
    }

    public void setProfile(Profile profile, boolean newBag) {
        this.profile = profile;
        this.bagInfo.setProfile(profile, newBag);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public List<String> getPayloadPaths() {
        ArrayList<String> pathList = new ArrayList<String>();
        Collection payload = this.bilBag.getPayload();
        if (payload != null) {
            for (BagFile bf : payload) {
                pathList.add(bf.getFilepath());
            }
        }
        return pathList;
    }

    public void addTagFile(File f) {
        this.changeToDirty();
        DefaultBag.isComplete(Status.UNKNOWN);
        String message = null;
        if (f != null) {
            try {
                this.bilBag.addFileAsTag(f);
            }
            catch (Exception e) {
                message = "Error adding file: " + f + " due to: " + e.getMessage();
            }
        }
    }

    public String write(Writer bw) {
        this.prepareBilBagInfoIfDirty();
        this.generateManifestFiles();
        if (this.isHoley && this.getFetch().getBaseURL() != null) {
            BagInfoTxt bagInfoTxt = this.bilBag.getBagInfoTxt();
            List manifests = this.bilBag.getPayloadManifests();
            List tags = this.bilBag.getTagManifests();
            HolePuncherImpl puncher = new HolePuncherImpl(new BagFactory());
            this.bilBag = puncher.makeHoley(this.bilBag, this.getFetch().getBaseURL(), true, true, false);
            this.bilBag.putBagFile((BagFile)bagInfoTxt);
            if (manifests != null) {
                for (Manifest manifest : manifests) {
                    this.bilBag.putBagFile((BagFile)manifest);
                }
            }
            if (tags != null) {
                for (Manifest tag : tags) {
                    this.bilBag.putBagFile((BagFile)tag);
                }
            }
        }
        String messages = this.writeBag(bw);
        if (bw.isCancelled()) {
            return "Save cancelled.";
        }
        return messages;
    }

    public String completeBag(CompleteVerifierImpl completeVerifier) {
        this.prepareBilBagInfoIfDirty();
        String messages = "";
        SimpleResult result = completeVerifier.verify(this.bilBag);
        if (completeVerifier.isCancelled()) {
            DefaultBag.isComplete(Status.UNKNOWN);
            return "Completeness check cancelled.";
        }
        if (!result.isSuccess()) {
            messages = "Bag is not complete:\n";
            messages = messages + result.toString();
        }
        DefaultBag.isComplete(result.isSuccess() ? Status.PASS : Status.FAILURE);
        if (!this.isNoProject()) {
            try {
                String msgs = this.validateMetadata();
                if (msgs != null) {
                    messages = messages + msgs;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msgs = "ERROR validating bag: \n" + ex.getMessage() + "\n";
                messages = messages + msgs;
            }
        }
        return messages;
    }

    public String validateMetadata() {
        this.prepareBilBagInfoIfDirty();
        String messages = null;
        this.updateStrategy();
        SimpleResult result = this.bilBag.verify(this.bagStrategy);
        if (result.toString() != null && !result.isSuccess()) {
            messages = "Bag-info fields are not all present for the project selected.\n";
            messages = messages + result.toString();
        }
        DefaultBag.isValidMetadata(result.isSuccess() ? Status.PASS : Status.FAILURE);
        return messages;
    }

    public String validateBag(ValidVerifierImpl validVerifier) {
        String msgs;
        this.prepareBilBagInfoIfDirty();
        String messages = "";
        SimpleResult result = validVerifier.verify(this.bilBag);
        if (validVerifier.isCancelled()) {
            DefaultBag.isValid(Status.UNKNOWN);
            return "Validation check cancelled.";
        }
        if (!result.isSuccess()) {
            messages = "Bag is not valid:\n";
            messages = messages + result.toString();
        }
        DefaultBag.isValid(result.isSuccess() ? Status.PASS : Status.FAILURE);
        if (result.isSuccess()) {
            DefaultBag.isComplete(Status.PASS);
        }
        if (!this.isNoProject() && (msgs = this.validateMetadata()) != null) {
            messages = messages + msgs;
        }
        return messages;
    }

    private static String fileStripSuffix(String filename) {
        StringTokenizer st = new StringTokenizer(filename, ".");
        return st.nextToken();
    }

    private String writeBag(Writer bw) {
        String s;
        Object messages = null;
        File localBagFile = null;
        String bagName = DefaultBag.fileStripSuffix(this.getRootDir().getName());
        File parentDir = this.getRootDir().getParentFile();
        log.debug("DefaultBag.writeBag parentDir: {}, bagName: {}", (Object)parentDir, (Object)bagName);
        this.setName(bagName);
        if (this.serialMode == 0) {
            localBagFile = new File(parentDir, this.getName());
        } else if (this.serialMode == 1) {
            s = bagName;
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                String sub = s.substring(i + 1);
                if (!sub.equalsIgnoreCase(ZIP_LABEL)) {
                    bagName = bagName + ".zip";
                }
            } else {
                bagName = bagName + ".zip";
            }
            localBagFile = new File(parentDir, bagName);
        } else if (this.serialMode == 2) {
            s = bagName;
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                if (!s.substring(i + 1).toLowerCase().equals(TAR_LABEL)) {
                    bagName = bagName + ".tar";
                }
            } else {
                bagName = bagName + ".tar";
            }
            localBagFile = new File(parentDir, bagName);
        } else if (this.serialMode == 3) {
            s = bagName;
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                if (!s.substring(i + 1).toLowerCase().equals(TAR_GZ_LABEL)) {
                    bagName = bagName + ".tar.gz";
                }
            } else {
                bagName = bagName + ".tar.gz";
            }
            localBagFile = new File(parentDir, bagName);
        } else if (this.serialMode == 4) {
            s = bagName;
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                if (!s.substring(i + 1).toLowerCase().equals(TAR_BZ2_LABEL)) {
                    bagName = bagName + ".tar.bz2";
                }
            } else {
                bagName = bagName + ".tar.bz2";
            }
            localBagFile = new File(parentDir, bagName);
        }
        this.setBagFile(localBagFile);
        log.info("Bag-Info to write: {}", (Object)this.bilBag.getBagInfoTxt());
        this.isSerialized(false);
        Bag newBag = bw.write(this.bilBag, localBagFile);
        if (newBag != null) {
            this.bilBag = newBag;
            this.isSerialized(true);
        }
        return null;
    }

    public void updateStrategy() {
        this.bagStrategy = this.getBagInfoStrategy();
    }

    private Verifier getBagInfoStrategy() {
        ArrayList<String> rulesList = new ArrayList<String>();
        HashMap<String, BagInfoField> fieldMap = this.getInfo().getFieldMap();
        if (fieldMap != null) {
            for (Map.Entry<String, BagInfoField> entry : fieldMap.entrySet()) {
                if (!entry.getValue().isRequired()) continue;
                rulesList.add(entry.getKey());
            }
        }
        String[] rules = rulesList.toArray(new String[rulesList.size()]);
        return new RequiredBagInfoTxtFieldsVerifier(rules);
    }

    private void generateManifestFiles() {
        DefaultCompleter completer = new DefaultCompleter(new BagFactory());
        if (this.isBuildPayloadManifest) {
            if (this.payloadManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.MD5.bagItAlgorithm)) {
                completer.setPayloadManifestAlgorithm(Manifest.Algorithm.MD5);
            } else if (this.payloadManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.SHA1.bagItAlgorithm)) {
                completer.setPayloadManifestAlgorithm(Manifest.Algorithm.SHA1);
            } else if (this.payloadManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.SHA256.bagItAlgorithm)) {
                completer.setPayloadManifestAlgorithm(Manifest.Algorithm.SHA256);
            } else if (this.payloadManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.SHA512.bagItAlgorithm)) {
                completer.setPayloadManifestAlgorithm(Manifest.Algorithm.SHA512);
            } else {
                completer.setPayloadManifestAlgorithm(Manifest.Algorithm.MD5);
            }
            completer.setClearExistingPayloadManifests(true);
        }
        if (this.isBuildTagManifest) {
            completer.setClearExistingTagManifests(true);
            completer.setGenerateTagManifest(true);
            if (this.tagManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.MD5.bagItAlgorithm)) {
                completer.setTagManifestAlgorithm(Manifest.Algorithm.MD5);
            } else if (this.tagManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.SHA1.bagItAlgorithm)) {
                completer.setTagManifestAlgorithm(Manifest.Algorithm.SHA1);
            } else if (this.tagManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.SHA256.bagItAlgorithm)) {
                completer.setTagManifestAlgorithm(Manifest.Algorithm.SHA256);
            } else if (this.tagManifestAlgorithm.equalsIgnoreCase(Manifest.Algorithm.SHA512.bagItAlgorithm)) {
                completer.setTagManifestAlgorithm(Manifest.Algorithm.SHA512);
            } else {
                completer.setTagManifestAlgorithm(Manifest.Algorithm.MD5);
            }
        }
        if (this.bilBag.getBagInfoTxt() != null) {
            completer.setGenerateBagInfoTxt(true);
        }
        this.bilBag = completer.complete(this.bilBag);
    }

    public void clear() {
        this.clearProfile();
        this.bagInfo.clearFields();
    }

    public void addField(BagInfoField field) {
        this.changeToDirty();
        DefaultBag.isValidMetadata(Status.UNKNOWN);
        this.bagInfo.addField(field);
    }

    public void removeBagInfoField(String key) {
        this.changeToDirty();
        DefaultBag.isValidMetadata(Status.UNKNOWN);
        this.bagInfo.removeField(key);
    }

    public void addFileToPayload(File file) {
        this.changeToDirty();
        DefaultBag.isComplete(Status.UNKNOWN);
        this.bilBag.addFileToPayload(file);
    }

    public Collection<BagFile> getTags() {
        return this.bilBag.getTags();
    }

    public void removeBagFile(String fileName) {
        this.changeToDirty();
        DefaultBag.isComplete(Status.UNKNOWN);
        this.bilBag.removeBagFile(fileName);
    }

    public void removePayloadDirectory(String fileName) {
        this.changeToDirty();
        DefaultBag.isComplete(Status.UNKNOWN);
        this.bilBag.removePayloadDirectory(fileName);
    }

    public Collection<BagFile> getPayload() {
        return this.bilBag.getPayload();
    }

    public FetchTxt getFetchTxt() {
        return this.bilBag.getFetchTxt();
    }

    private void changeToDirty() {
        this.dirty = true;
        DefaultBag.isValid(Status.UNKNOWN);
    }

    private void prepareBilBagInfoIfDirty() {
        if (this.dirty) {
            this.bagInfo.prepareBilBagInfo(this.bilBag.getBagInfoTxt());
        }
    }
}

