/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import cool.pandora.modeller.bag.BaggerProfile;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.bag.impl.DefaultBagInfo;
import cool.pandora.modeller.ui.jpanel.base.BagInfoForm;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.base.OrganizationProfileForm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.richclient.form.FormModelHelper;

public class BagInfoInputPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(BagInfoInputPane.class);
    private final BagView bagView;
    private DefaultBag defaultBag;
    private BaggerProfile bagProfile;
    private BagInfoForm bagInfoForm = null;
    private OrganizationProfileForm profileForm = null;

    public BagInfoInputPane(BagView bagView) {
        this.bagView = bagView;
        this.defaultBag = bagView.getBag();
        this.populateForms(this.defaultBag);
        InputMap im = this.getInputMap();
        im.put(KeyStroke.getKeyStroke("F2"), "tabNext");
        ActionMap am = this.getActionMap();
        am.put("tabNext", new AbstractAction("tabNext"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                int selected = BagInfoInputPane.this.getSelectedIndex();
                int count = BagInfoInputPane.this.getComponentCount();
                if (selected >= 0 && selected < count - 1) {
                    BagInfoInputPane.this.setSelectedIndex(selected + 1);
                } else {
                    BagInfoInputPane.this.setSelectedIndex(0);
                }
                BagInfoInputPane.this.invalidate();
                BagInfoInputPane.this.repaint();
            }
        });
        this.setActionMap(am);
    }

    public void enableForms(boolean b) {
        this.profileForm.setEnabled(b);
        this.profileForm.getControl().invalidate();
        this.bagInfoForm.setEnabled(b);
        this.bagInfoForm.getControl().invalidate();
        this.setEnabled(b);
        this.invalidate();
    }

    public void populateForms(DefaultBag bag) {
        this.defaultBag = bag;
        DefaultBagInfo bagInfo = bag.getInfo();
        if (this.bagProfile == null) {
            this.bagProfile = new BaggerProfile();
        }
        this.bagProfile.setOrganization(bagInfo.getBagOrganization());
        this.bagProfile.setToContact(bagInfo.getToContact());
        HierarchicalFormModel profileFormModel = FormModelHelper.createCompoundFormModel((Object)this.bagProfile);
        this.profileForm = new OrganizationProfileForm((FormModel)FormModelHelper.createChildPageFormModel((HierarchicalFormModel)profileFormModel, null), this.bagView);
        HierarchicalFormModel infoFormModel = FormModelHelper.createCompoundFormModel((Object)bagInfo);
        this.bagInfoForm = new BagInfoForm((FormModel)FormModelHelper.createChildPageFormModel((HierarchicalFormModel)infoFormModel, null), this.bagView, bagInfo.getFieldMap());
        this.createTabbedUiComponentsWithForms();
    }

    private void createTabbedUiComponentsWithForms() {
        this.removeAll();
        this.validate();
        this.setName("Profile");
        this.bagInfoForm.getControl().setToolTipText(this.bagView.getPropertyMessage("infoinputpane.tab.details.help"));
        this.addTab(this.bagView.getPropertyMessage("infoInputPane.tab.details"), this.bagInfoForm.getControl());
        this.profileForm.getControl().setToolTipText("Profile Form");
    }

    private void verifyForms(DefaultBag bag) {
        if (this.profileForm.hasErrors()) {
            throw new RuntimeException("Bag-Info has errors");
        }
        this.profileForm.commit();
        if (this.bagInfoForm.hasErrors()) {
            throw new RuntimeException("Bag-Info has errors");
        }
        this.bagInfoForm.commit();
        this.updateBagInfo(bag);
    }

    public void updateForms(DefaultBag bag) {
        Component[] components;
        this.verifyForms(bag);
        this.createTabbedUiComponentsWithForms();
        for (Component c : components = this.bagInfoForm.getControl().getComponents()) {
            c.invalidate();
            c.repaint();
        }
        this.bagInfoForm.getControl().invalidate();
        this.profileForm.getControl().invalidate();
        this.invalidate();
        this.repaint();
    }

    public static void updateProject(BagView bagView) {
        bagView.infoInputPane.updateInfoFormsPane();
    }

    private void updateBagInfo(DefaultBag bag) {
        HashMap<String, String> map = this.bagInfoForm.getBagInfoMap();
        bag.updateBagInfo(map);
    }

    @Override
    public void requestFocus() {
        this.bagInfoForm.getControl().requestFocus();
    }
}

