/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import cool.pandora.modeller.ui.NoTabTextArea;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.builder.TableFormBuilder;
import org.springframework.richclient.layout.TableLayoutBuilder;

public class BagTableFormBuilder
extends TableFormBuilder {
    private ComponentFactory componentFactory;

    public BagTableFormBuilder(BindingFactory bindingFactory) {
        super(bindingFactory);
    }

    protected ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = (ComponentFactory)ApplicationServicesLocator.services().getService(ComponentFactory.class);
        }
        return this.componentFactory;
    }

    public JComponent[] add(boolean isRequired, String label, JComponent checkbox) {
        JTextField textField = new JTextField();
        return this.addBinding(isRequired, label, textField, checkbox);
    }

    public JComponent[] addList(boolean isRequired, String label, Collection<String> elements, String defaultValue, JComponent checkbox) {
        ArrayList<String> listModel = new ArrayList<String>();
        listModel.addAll(elements);
        JComboBox<String> dropDownTextField = new JComboBox<String>(listModel.toArray(new String[listModel.size()]));
        dropDownTextField.setSelectedItem(defaultValue);
        Object obj = dropDownTextField.getSelectedItem();
        dropDownTextField.setSelectedItem(obj);
        return this.addBinding(isRequired, label, dropDownTextField, checkbox);
    }

    public JComponent[] addTextArea(boolean isRequired, String label, JComponent checkbox) {
        NoTabTextArea textArea = new NoTabTextArea(3, 40);
        return this.addBinding(isRequired, label, textArea, checkbox);
    }

    private JComponent[] addBinding(boolean isRequired, String labelName, JComponent component, JComponent removeButton) {
        JButton reqComp;
        removeButton.setFocusable(false);
        JLabel label = new JLabel(labelName);
        label.setToolTipText("Double-Click to Edit");
        TableLayoutBuilder layoutBuilder = this.getLayoutBuilder();
        if (!layoutBuilder.hasGapToLeft()) {
            layoutBuilder.gapCol();
        }
        layoutBuilder.cell((JComponent)label, "colSpec=left:pref:noGrow");
        if (isRequired) {
            JButton b = new JButton("R");
            b.setForeground(Color.red);
            b.setOpaque(false);
            b.setBorderPainted(false);
            reqComp = b;
        } else {
            JButton b = new JButton("");
            b.setOpaque(false);
            b.setBorderPainted(false);
            reqComp = b;
        }
        reqComp.setFocusable(false);
        layoutBuilder.cell((JComponent)reqComp, "colSpec=left:pref:noGrow");
        layoutBuilder.cell(component, "colSpec=fill:pref:grow");
        layoutBuilder.labelGapCol();
        layoutBuilder.cell(removeButton, "colSpec=left:pref:noGrow");
        layoutBuilder.labelGapCol();
        return new JComponent[]{label, reqComp, component, removeButton};
    }
}

