/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import cool.pandora.modeller.model.Status;
import cool.pandora.modeller.model.StatusModel;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class StatusImageLabel
extends JLabel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final String PASS_STATUS_ICON = "status.success.icon";
    private static final String FAILURE_STATUS_ICON = "status.fail.icon";
    private static final String UNKNOWN_STATUS_ICON = "status.unknown.icon";

    public StatusImageLabel(StatusModel model) {
        super("");
        this.changeIcon(model.getStatus());
        model.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Status newValue = (Status)evt.getNewValue();
        this.changeIcon(newValue);
    }

    private void changeIcon(Status status) {
        ImageIcon icon;
        if (status == Status.PASS) {
            icon = new ImageIcon(ApplicationContextUtil.getImage(PASS_STATUS_ICON));
            this.setToolTipText(ApplicationContextUtil.getMessage("consolepane.status.pass.help"));
        } else if (status == Status.FAILURE) {
            icon = new ImageIcon(ApplicationContextUtil.getImage(FAILURE_STATUS_ICON));
            this.setToolTipText(ApplicationContextUtil.getMessage("consolepane.status.fail.help"));
        } else {
            icon = new ImageIcon(ApplicationContextUtil.getImage(UNKNOWN_STATUS_ICON));
            this.setToolTipText(ApplicationContextUtil.getMessage("consolepane.status.unknown.help"));
        }
        this.setIcon(icon);
    }
}

