/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.writer.Writer;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import gov.loc.repository.bagit.writer.impl.ZipWriter;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.dialog.ConfirmationDialog;

public class SaveBagHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(SaveBagHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;
    private File tmpRootPath;
    private boolean clearAfterSaving = false;
    private String messages;

    public SaveBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultBag bag = this.bagView.getBag();
        this.bagView.infoInputPane.updateBagHandler.updateBag(bag);
        if (this.bagView.getBagRootPath().exists()) {
            this.tmpRootPath = this.bagView.getBagRootPath();
            this.confirmWriteBag();
        } else {
            this.saveBag(this.bagView.getBagRootPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        DefaultBag bag = this.bagView.getBag();
        try {
            BagFactory bagFactory = new BagFactory();
            Writer bagWriter = SaveBagHandler.getWriter(bagFactory, bag);
            if (bagWriter != null) {
                bagWriter.addProgressListener((ProgressListener)this.bagView.task);
                this.bagView.longRunningProcess = bagWriter;
                this.messages = bag.write(bagWriter);
                if (this.messages != null && !this.messages.trim().isEmpty()) {
                    BagView.showWarningErrorDialog("Warning - bag not saved", "Problem saving bag:\n" + this.messages);
                } else {
                    BagView.showWarningErrorDialog("Bag saved", "Bag saved successfully.\n");
                }
            } else {
                BagView.showWarningErrorDialog("Warning - bag not saved", "Could not get writer for bag");
            }
            SwingUtilities.invokeLater(() -> {
                DefaultBag bag1 = this.bagView.getBag();
                if (bag1.isSerialized()) {
                    if (this.clearAfterSaving) {
                        BagView.statusBarEnd();
                        this.bagView.clearBagHandler.clearExistingBag();
                        this.setClearAfterSaving(false);
                    } else {
                        if (bag1.isValidateOnSave()) {
                            this.bagView.validateBagHandler.validateBag();
                        }
                        BagView.statusBarEnd();
                        File bagFile = bag1.getBagFile();
                        log.info("BagView.openExistingBag: {}", (Object)bagFile);
                        this.bagView.openBagHandler.openExistingBag(bagFile);
                        this.bagView.updateSaveBag();
                    }
                } else {
                    ApplicationContextUtil.addConsoleMessage(this.messages);
                    this.bagView.updateManifestPane();
                }
            });
        }
        finally {
            this.bagView.task.done();
            BagView.statusBarEnd();
        }
    }

    private static Writer getWriter(BagFactory bagFactory, DefaultBag bag) {
        if (bag.getSerialMode() == 0) {
            return new FileSystemWriter(bagFactory);
        }
        if (bag.getSerialMode() == 1) {
            return new ZipWriter(bagFactory);
        }
        return null;
    }

    void setTmpRootPath(File f) {
        this.tmpRootPath = f;
    }

    void setClearAfterSaving(boolean b) {
        this.clearAfterSaving = b;
    }

    void saveBag(File file) {
        DefaultBag bag = this.bagView.getBag();
        bag.setRootDir(file);
        this.bagView.statusBarBegin(this, "Writing bag...", null);
    }

    void confirmWriteBag() {
        ConfirmationDialog dialog = new ConfirmationDialog(){
            boolean isCancel = true;

            protected void onConfirm() {
                DefaultBag bag = SaveBagHandler.this.bagView.getBag();
                if (bag.getSize() > 0x6400000L) {
                    SaveBagHandler.this.confirmAcceptBagSize();
                } else {
                    SaveBagHandler.this.bagView.setBagRootPath(SaveBagHandler.this.tmpRootPath);
                    SaveBagHandler.this.saveBag(SaveBagHandler.this.bagView.getBagRootPath());
                }
            }

            protected void onCancel() {
                super.onCancel();
                if (this.isCancel) {
                    SaveBagHandler.this.cancelWriteBag();
                    this.isCancel = false;
                }
            }
        };
        dialog.setCloseAction(CloseAction.DISPOSE);
        dialog.setTitle(this.bagView.getPropertyMessage("bag.dialog.title.create"));
        dialog.setConfirmationMessage(this.bagView.getPropertyMessage("bag.dialog.message.create"));
        dialog.showDialog();
    }

    private void cancelWriteBag() {
        this.clearAfterSaving = false;
    }

    private void confirmAcceptBagSize() {
        ConfirmationDialog dialog = new ConfirmationDialog(){

            protected void onConfirm() {
                SaveBagHandler.this.bagView.setBagRootPath(SaveBagHandler.this.tmpRootPath);
                SaveBagHandler.this.saveBag(SaveBagHandler.this.bagView.getBagRootPath());
            }
        };
        dialog.setCloseAction(CloseAction.DISPOSE);
        dialog.setTitle(this.bagView.getPropertyMessage("bag.dialog.title.create"));
        dialog.setConfirmationMessage(this.bagView.getPropertyMessage("bag.dialog.message.accept"));
        dialog.showDialog();
    }

    public void save(File file) {
        DefaultBag bag = this.bagView.getBag();
        File newfile = file != null ? file : this.bagView.getBagRootPath();
        bag.setName(newfile.getName());
        File bagFile = new File(newfile, bag.getName());
        if (bagFile.exists()) {
            this.tmpRootPath = newfile;
            this.confirmWriteBag();
        } else if (bag.getSize() > 0x6400000L) {
            this.tmpRootPath = newfile;
            this.confirmAcceptBagSize();
        } else {
            this.bagView.setBagRootPath(newfile);
            this.saveBag(this.bagView.getBagRootPath());
        }
        String fileName = bagFile.getAbsolutePath();
        this.bagView.infoInputPane.setBagName(fileName);
        this.bagView.getControl().invalidate();
    }
}

