/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.verify.CompleteVerifier;
import gov.loc.repository.bagit.verify.ManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import gov.loc.repository.bagit.verify.impl.ParallelManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.impl.ValidVerifierImpl;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public class ValidateBagHandler
extends AbstractAction
implements Progress {
    private static final long serialVersionUID = 1L;
    private final BagView bagView;
    private String messages;

    public ValidateBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validateBag();
    }

    void validateBag() {
        this.bagView.statusBarBegin(this, "Validating bag...", "verifying file checksum");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        DefaultBag bag = this.bagView.getBag();
        try {
            CompleteVerifierImpl completeVerifier = new CompleteVerifierImpl();
            ParallelManifestChecksumVerifier manifestVerifier = new ParallelManifestChecksumVerifier();
            ValidVerifierImpl validVerifier = new ValidVerifierImpl((CompleteVerifier)completeVerifier, (ManifestChecksumVerifier)manifestVerifier);
            validVerifier.addProgressListener((ProgressListener)this.bagView.task);
            this.bagView.longRunningProcess = validVerifier;
            this.messages = bag.validateBag(validVerifier);
            if (this.messages != null && !this.messages.trim().isEmpty()) {
                BagView.showWarningErrorDialog("Warning - validation failed", "Validation result: " + this.messages);
            } else {
                BagView.showWarningErrorDialog("Validation Dialog", "Validation successful.");
            }
            SwingUtilities.invokeLater(() -> ApplicationContextUtil.addConsoleMessage(this.messages));
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.bagView.longRunningProcess.isCancelled()) {
                BagView.showWarningErrorDialog("Validation cancelled", "Validation cancelled.");
            } else {
                BagView.showWarningErrorDialog("Warning - validation interrupted", "Error trying validate bag: " + e.getMessage());
            }
        }
        finally {
            this.bagView.task.done();
            BagView.statusBarEnd();
        }
    }
}

