/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.common;

import cool.pandora.modeller.CanvasPageMap;
import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.PageIdMap;
import cool.pandora.modeller.hOCRData;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class NodeMap {
    private NodeMap() {
    }

    public static Map<String, String> getBBoxMap(hOCRData hocr, List<String> pageIdList) {
        HashMap<String, String> bboxMap = new HashMap<String, String>();
        for (String pageId : pageIdList) {
            String bbox = DocManifestBuilder.getBboxForId((hOCRData)hocr, (String)pageId);
            bboxMap.put(pageId, bbox);
        }
        return bboxMap;
    }

    public static Map<String, String> getBBoxAreaMap(hOCRData hocr, List<String> areaIdList) {
        HashMap<String, String> bboxMap = new HashMap<String, String>();
        for (String areaId : areaIdList) {
            String bbox = DocManifestBuilder.getBboxForId((hOCRData)hocr, (String)areaId);
            bboxMap.put(areaId, bbox);
        }
        return bboxMap;
    }

    public static Map<String, String> getBBoxLineMap(hOCRData hocr, List<String> lineIdList) {
        HashMap<String, String> bboxMap = new HashMap<String, String>();
        for (String lineId : lineIdList) {
            String bbox = DocManifestBuilder.getBboxForId((hOCRData)hocr, (String)lineId);
            bboxMap.put(lineId, bbox);
        }
        return bboxMap;
    }

    public static Map<String, String> getBBoxWordMap(hOCRData hocr, List<String> wordIdList) {
        HashMap<String, String> bboxMap = new HashMap<String, String>();
        for (String wordId : wordIdList) {
            String bbox = DocManifestBuilder.getBboxForId((hOCRData)hocr, (String)wordId);
            bboxMap.put(wordId, bbox);
        }
        return bboxMap;
    }

    public static Map<String, String> getCharWordMap(hOCRData hocr, List<String> wordIdList) {
        HashMap<String, String> charMap = new HashMap<String, String>();
        for (String wordId : wordIdList) {
            String chars = DocManifestBuilder.getCharsForId((hOCRData)hocr, (String)wordId);
            charMap.put(wordId, chars);
        }
        return charMap;
    }

    public static Map<String, String> getCanvasPageMap(List<String> pageIdList, URI canvasContainerURI) {
        try {
            CanvasPageMap canvasPageMap = CanvasPageMap.init().canvasContainerURI(canvasContainerURI).pageIdList(pageIdList).build();
            return canvasPageMap.render();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, String> getPageIdMap(List<String> pageIdList) {
        try {
            PageIdMap pageIdMap = PageIdMap.init().pageIdList(pageIdList).build();
            return pageIdMap.render();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, List<String>> getAreaIdMap(hOCRData hocr, List<String> pageIdList) {
        HashMap<String, List<String>> nodemap = new HashMap<String, List<String>>();
        for (String pageId : pageIdList) {
            List areaIdList = DocManifestBuilder.getAreaIdListforPage((hOCRData)hocr, (String)pageId);
            for (int i = 0; i < areaIdList.size(); ++i) {
                String areaId = StringUtils.substringAfter((String)((String)areaIdList.get(i)), (String)"_");
                areaIdList.set(i, areaId);
            }
            pageId = StringUtils.substringAfter((String)pageId, (String)"_");
            nodemap.put(pageId, areaIdList);
        }
        return nodemap;
    }

    public static Map<String, List<String>> getLineIdMap(hOCRData hocr, List<String> areaIdList) {
        HashMap<String, List<String>> nodemap = new HashMap<String, List<String>>();
        for (String areaId : areaIdList) {
            List lineIdList = DocManifestBuilder.getLineIdListforArea((hOCRData)hocr, (String)areaId);
            for (int i = 0; i < lineIdList.size(); ++i) {
                String lineId = StringUtils.substringAfter((String)((String)lineIdList.get(i)), (String)"_");
                lineIdList.set(i, lineId);
            }
            areaId = StringUtils.substringAfter((String)areaId, (String)"_");
            nodemap.put(areaId, lineIdList);
        }
        return nodemap;
    }

    public static Map<String, List<String>> getWordIdMap(hOCRData hocr, List<String> lineIdList) {
        HashMap<String, List<String>> nodemap = new HashMap<String, List<String>>();
        for (String lineId : lineIdList) {
            List wordIdList = DocManifestBuilder.getWordIdListforLine((hOCRData)hocr, (String)lineId);
            for (int i = 0; i < wordIdList.size(); ++i) {
                String wordId = StringUtils.substringAfter((String)((String)wordIdList.get(i)), (String)"_");
                wordIdList.set(i, wordId);
            }
            lineId = StringUtils.substringAfter((String)lineId, (String)"_");
            nodemap.put(lineId, wordIdList);
        }
        return nodemap;
    }

    public static Map<String, List<String>> getWordsForPageMap(hOCRData hocr, List<String> pageIdList) {
        HashMap<String, List<String>> nodemap = new HashMap<String, List<String>>();
        for (String pageId : pageIdList) {
            List wordIdList = DocManifestBuilder.getWordIdListforPage((hOCRData)hocr, (String)pageId);
            for (int i = 0; i < wordIdList.size(); ++i) {
                String wordId = StringUtils.substringAfter((String)((String)wordIdList.get(i)), (String)"_");
                wordIdList.set(i, wordId);
            }
            pageId = StringUtils.substringAfter((String)pageId, (String)"_");
            nodemap.put(pageId, wordIdList);
        }
        return nodemap;
    }
}

