/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.XmlFileWriter;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.iiif.ResourceIdentifierList;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.CreateXmlFilesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.URIResolver;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateXmlFilesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(CreateXmlFilesHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateXmlFilesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreateXmlFilesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.xmlfilecreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        ResourceIdentifierList idList = new ResourceIdentifierList(this.bagView);
        ArrayList<String> resourceIDList = idList.getResourceIdentifierList();
        String collectionId = URIResolver.ContainerURIResolverNormal.getMapValue(map, "CollectionID");
        String objektId = URIResolver.ContainerURIResolverNormal.getMapValue(map, "ObjektID");
        for (String resourceId : resourceIDList) {
            ByteArrayOutputStream resourceFile = null;
            try {
                resourceFile = CreateXmlFilesHandler.getXmlOutputStream(collectionId, objektId, resourceId);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            assert (resourceFile != null);
            ByteArrayInputStream in = new ByteArrayInputStream(resourceFile.toByteArray());
            String filename = resourceId + ".xml";
            String contentType = "application/xml";
            URI destinationURI = IIIFObjectURI.getDestinationURI(map, filename);
            try {
                ModellerClient.doStreamPut((URI)destinationURI, (ByteArrayInputStream)in, (String)"application/xml");
                ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
    }

    void openCreateXmlFilesFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateXmlFilesFrame createXmlFilesFrame = new CreateXmlFilesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.xmlfiles"));
        createXmlFilesFrame.setBag(bag);
        createXmlFilesFrame.setVisible(true);
    }

    private static ByteArrayOutputStream getXmlOutputStream(String collectionId, String objektId, String resourceId) throws JAXBException {
        ByteArrayOutputStream xmlFileWriter = XmlFileWriter.write().collectionId(collectionId).objektId(objektId).resourceId(resourceId).build();
        return xmlFileWriter;
    }
}

