/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.templates.CanvasScope;
import cool.pandora.modeller.templates.MetadataTemplate;
import cool.pandora.modeller.templates.Scope;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.PatchCanvasFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.util.ResourceIntegerValue;
import cool.pandora.modeller.util.ResourceList;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchCanvasHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchCanvasHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchCanvasHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.canvaspatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI resourceContainerURI = IIIFObjectURI.getResourceContainerURI(map);
        URI canvasContainerURI = IIIFObjectURI.getCanvasContainerURI(map);
        URI ListContainerURI = IIIFObjectURI.getListContainerURI(map);
        ResourceList canvasList = new ResourceList(canvasContainerURI);
        ArrayList canvasesList = canvasList.getResourceList();
        ResourceList resourceList = new ResourceList(resourceContainerURI);
        ArrayList resourcesList = resourceList.getResourceList();
        ResourceList listList = new ResourceList(ListContainerURI);
        ArrayList listsList = listList.getResourceList();
        Iterator i1 = canvasesList.iterator();
        Iterator i2 = resourcesList.iterator();
        Iterator i3 = canvasesList.iterator();
        Iterator i4 = listsList.iterator();
        LinkedHashMap canvasResourceMap = new LinkedHashMap();
        LinkedHashMap canvasListMap = new LinkedHashMap();
        while (i1.hasNext() && i2.hasNext()) {
            canvasResourceMap.put(i1.next(), i2.next());
        }
        while (i3.hasNext() && i4.hasNext()) {
            canvasListMap.put(i3.next(), i4.next());
        }
        for (String canvasURI : canvasesList) {
            InputStream rdfBody = PatchCanvasHandler.getCanvasMetadata((String)canvasResourceMap.get(canvasURI), (String)canvasListMap.get(canvasURI));
            URI destinationURI = URI.create(canvasURI);
            try {
                ModellerClient.doPatch((URI)destinationURI, (InputStream)rdfBody);
                ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchCanvasFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchCanvasFrame patchCanvasFrame = new PatchCanvasFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.canvas"));
        patchCanvasFrame.setBag(bag);
        patchCanvasFrame.setVisible(true);
    }

    private static InputStream getCanvasMetadata(String resourceURI, String listURI) {
        List<CanvasScope.Prefix> prefixes = Arrays.asList(new CanvasScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new CanvasScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"), new CanvasScope.Prefix("PREFIX sc: <http://iiif.io/api/presentation/2#>"), new CanvasScope.Prefix("PREFIX oa: <http://www.w3.org/ns/oa#>"), new CanvasScope.Prefix("PREFIX exif: <http://www.w3.org/2003/12/exif/ns#>"));
        ResourceIntegerValue resourceHeight = ResourceIntegerValue.init().resourceURI(resourceURI + "/fcr:metadata").resourceProperty("http://www.w3.org/2003/12/exif/ns#height").build();
        int resheight = (Integer)resourceHeight.render().get(0);
        ResourceIntegerValue resourceWidth = ResourceIntegerValue.init().resourceURI(resourceURI + "/fcr:metadata").resourceProperty("http://www.w3.org/2003/12/exif/ns#width").build();
        int reswidth = (Integer)resourceWidth.render().get(0);
        String canvasLabel = StringUtils.substringAfter((String)listURI, (String)"list/");
        CanvasScope scope = new CanvasScope().fedoraPrefixes(prefixes).resourceURI(resourceURI).listURI(listURI).canvasLabel(canvasLabel).canvasHeight(resheight).canvasWidth(reswidth);
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-canvas.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = StringEscapeUtils.unescapeXml((String)metadataTemplate.render());
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }
}

