/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.BaggerFileEntity;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.templates.MetadataTemplate;
import cool.pandora.modeller.templates.ResourceScope;
import cool.pandora.modeller.templates.Scope;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.PatchResourceFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.util.ImageIOUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchResourceHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchResourceHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchResourceHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.resourcepatched");
        DefaultBag bag = this.bagView.getBag();
        List payload = bag.getPayloadPaths();
        HashMap map = bag.getInfo().getFieldMap();
        URI resourceContainer = IIIFObjectURI.getResourceContainerURI(map);
        String basePath = "data";
        Path rootDir = this.bagView.getBagRootPath().toPath();
        for (String filePath : payload) {
            String filename = BaggerFileEntity.removeBasePath((String)"data", (String)filePath);
            String destinationURI = PatchResourceHandler.getDestinationURI(resourceContainer, filename);
            Path absoluteFilePath = rootDir.resolve(filePath);
            File resourceFile = absoluteFilePath.toFile();
            String formatName = null;
            Dimension dim = null;
            InputStream rdfBody = null;
            URI uri = URI.create(destinationURI);
            try {
                formatName = ImageIOUtil.getImageMIMEType((File)resourceFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dim = ImageIOUtil.getImageDimensions((File)resourceFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dim != null) {
                double imgWidth = dim.getWidth();
                int iw = (int)imgWidth;
                double imgHeight = dim.getHeight();
                int ih = (int)imgHeight;
                try {
                    rdfBody = PatchResourceHandler.getResourceMetadata(map, filename, formatName, iw, ih);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                ModellerClient.doPatch((URI)uri, rdfBody);
                ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchResourceFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchResourceFrame patchResourcesFrame = new PatchResourceFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch"));
        patchResourcesFrame.setBag(bag);
        patchResourcesFrame.setVisible(true);
    }

    private static String getDestinationURI(URI resourceContainer, String filename) {
        return resourceContainer.toString() + filename + "/fcr:metadata";
    }

    private static InputStream getResourceMetadata(Map<String, BagInfoField> map, String filename, String formatName, int iw, int ih) {
        List<ResourceScope.Prefix> prefixes = Arrays.asList(new ResourceScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new ResourceScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"), new ResourceScope.Prefix("PREFIX dc: <http://purl.org/dc/elements/1.1/>"), new ResourceScope.Prefix("PREFIX svcs: <http://rdfs.org/sioc/services#>"), new ResourceScope.Prefix("PREFIX exif: <http://www.w3.org/2003/12/exif/ns#>"), new ResourceScope.Prefix("PREFIX dctypes: <http://purl.org/dc/dcmitype/>"));
        ResourceScope scope = new ResourceScope().fedoraPrefixes(prefixes).filename(filename).serviceURI(PatchResourceHandler.getServiceURI(map, filename)).formatName(formatName).imgHeight(ih).imgWidth(iw);
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-res.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = metadataTemplate.render();
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }

    private static String getServiceURI(Map<String, BagInfoField> map, String filename) {
        String separator = "_";
        String serviceURI = PatchResourceHandler.getMapValue(map, "IIIFServiceBaseURI");
        String path = PatchResourceHandler.getMapValue(map, "CollectionRoot") + "_" + PatchResourceHandler.getMapValue(map, "CollectionID") + "_" + PatchResourceHandler.getMapValue(map, "ObjektID") + "_" + PatchResourceHandler.getMapValue(map, "IIIFResourceContainer") + "_" + filename;
        return serviceURI + path.replace("tif", "jp2");
    }

    private static String getMapValue(Map<String, BagInfoField> map, String key) {
        BagInfoField IIIFProfileKey = map.get(key);
        return IIIFProfileKey.getValue();
    }
}

