/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.templates.CollectionScope;
import cool.pandora.modeller.templates.MetadataTemplate;
import cool.pandora.modeller.templates.Scope;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.iiif.ResourceIdentifierList;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.PatchSequenceFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.URIResolver;
import cool.pandora.modeller.util.RDFCollectionWriter;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchSequenceHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchSequenceHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchSequenceHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.sequencepatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        ResourceIdentifierList idList = new ResourceIdentifierList(this.bagView);
        ArrayList<String> resourceIDList = idList.getResourceIdentifierList();
        String collectionPredicate = "http://iiif.io/api/presentation/2#hasCanvases";
        URI canvasContainerIRI = IIIFObjectURI.getCanvasContainerURI(map);
        InputStream rdfBody = PatchSequenceHandler.getSequenceMetadata(resourceIDList, "http://iiif.io/api/presentation/2#hasCanvases", canvasContainerIRI);
        URI destinationURI = PatchSequenceHandler.getDestinationURI(map);
        try {
            ModellerClient.doPatch((URI)destinationURI, (InputStream)rdfBody);
            ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
        }
        catch (ModellerClientFailedException e) {
            ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchSequenceFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchSequenceFrame patchSequencesFrame = new PatchSequenceFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.sequence"));
        patchSequencesFrame.setBag(bag);
        patchSequencesFrame.setVisible(true);
    }

    private static URI getDestinationURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("IIIFSequenceContainer").resource("normal").pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    private static InputStream getSequenceMetadata(ArrayList<String> resourceIDList, String collectionPredicate, URI resourceContainerIRI) {
        RDFCollectionWriter collectionWriter = RDFCollectionWriter.collection().idList(resourceIDList).collectionPredicate(collectionPredicate).resourceContainerIRI(resourceContainerIRI.toString()).build();
        String collection = collectionWriter.render();
        List<CollectionScope.Prefix> prefixes = Arrays.asList(new CollectionScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new CollectionScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"));
        CollectionScope scope = new CollectionScope().fedoraPrefixes(prefixes).sequenceGraph(collection);
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-seq.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = StringEscapeUtils.unescapeXml((String)metadataTemplate.render());
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }
}

