/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.CreateWordsFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.URIResolver;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateWordsHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(CreateWordsHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateWordsHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreateWordsFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.wordcreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        String url = bag.gethOCRResource();
        List wordIdList = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            wordIdList = DocManifestBuilder.getWordIdList((hOCRData)hocr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (wordIdList != null);
        for (String resourceID : wordIdList) {
            resourceID = StringUtils.substringAfter((String)resourceID, (String)"_");
            URI wordObjectURI = CreateWordsHandler.getWordObjectURI(map, resourceID);
            try {
                ModellerClient.doPut((URI)wordObjectURI);
                ApplicationContextUtil.addConsoleMessage(message + " " + wordObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openCreateWordsFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateWordsFrame createWordsFrame = new CreateWordsFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.words"));
        createWordsFrame.setBag(bag);
        createWordsFrame.setVisible(true);
    }

    public static URI getWordContainerURI(Map<String, BagInfoField> map) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextWordContainer").pathType(4).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }

    private static URI getWordObjectURI(Map<String, BagInfoField> map, String resourceID) {
        try {
            URIResolver uriResolver = URIResolver.resolve().map(map).containerKey("TextWordContainer").resource(resourceID).pathType(5).build();
            return uriResolver.render();
        }
        catch (URISyntaxException e) {
            log.debug(e.getMessage());
            return null;
        }
    }
}

