/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.BagInfoInputPane;
import cool.pandora.modeller.ui.handlers.base.UpdateBagHandler;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.LayoutUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class InfoFormsPane
extends JScrollPane {
    private static final long serialVersionUID = -5988111446773491301L;
    private final BagView bagView;
    private final DefaultBag bag;
    private JPanel infoPanel;
    protected JPanel serializeGroupPanel;
    public BagInfoInputPane bagInfoInputPane;
    public UpdateBagHandler updateBagHandler;
    private JLabel bagNameValue;
    public JButton removeProjectButton;
    public JLabel bagVersionValue;
    private JLabel bagProfileValue;
    public JLabel holeyValue;
    public JLabel serializeLabel;
    public JLabel serializeValue;
    public JCheckBox defaultProject;
    public JRadioButton noneButton;
    public JRadioButton zipButton;
    public JRadioButton tarButton;
    public JRadioButton tarGzButton;
    public JRadioButton tarBz2Button;

    InfoFormsPane(BagView bagView) {
        this.bagView = bagView;
        this.bag = bagView.getBag();
        this.createUiComponent();
        this.updateBagHandler = new UpdateBagHandler(bagView);
    }

    public void setProfile(String profileName) {
        this.bagProfileValue.setText(profileName);
    }

    private void createUiComponent() {
        JPanel bagSettingsPanel = this.createSettingsPanel();
        this.infoPanel = new JPanel(new GridBagLayout());
        this.infoPanel.setToolTipText(this.bagView.getPropertyMessage("bagView.bagInfoInputPane.help"));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.infoPanel.setBorder(emptyBorder);
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(0, 0, 1, 1, 0, 0, 2, 17);
        this.infoPanel.add((Component)bagSettingsPanel, gbc);
        this.bagInfoInputPane = new BagInfoInputPane(this.bagView);
        this.bagInfoInputPane.setToolTipText(this.bagView.getPropertyMessage("bagView.bagInfoInputPane.help"));
        this.bagInfoInputPane.setEnabled(false);
        gbc = LayoutUtil.buildGridBagConstraints(0, 1, 1, 1, 1, 1, 1, 17);
        this.infoPanel.add((Component)this.bagInfoInputPane, gbc);
        this.setViewportView(this.infoPanel);
    }

    private JPanel createSettingsPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(5, 5));
        JPanel mainPanel = new JPanel();
        contentPane.add((Component)mainPanel, "North");
        mainPanel.setLayout(new BorderLayout(0, 0));
        mainPanel.add((Component)this.createBagSettingsPanel(), "Center");
        return contentPane;
    }

    private JPanel createBagSettingsPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        int row = 0;
        JLabel lblBagName = new JLabel(this.bagView.getPropertyMessage("bag.label.name"));
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 0, 0, 0, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)lblBagName, gbc);
        this.bagNameValue = new JLabel(this.bagView.getPropertyMessage("bag.label.noname"));
        gbc = LayoutUtil.buildGridBagConstraints(1, row, 3, 1, 3, 1, 2, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)this.bagNameValue, gbc);
        JLabel bagProfileLabel = new JLabel("Profile:");
        gbc = LayoutUtil.buildGridBagConstraints(0, ++row, 1, 1, 0, 0, 0, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)bagProfileLabel, gbc);
        this.bagProfileValue = new JLabel("");
        gbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 1, 1, 2, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)this.bagProfileValue, gbc);
        JLabel bagVersionLabel = new JLabel(this.bagView.getPropertyMessage("bag.label.version"));
        bagVersionLabel.setToolTipText(this.bagView.getPropertyMessage("bag.versionlist.help"));
        gbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 0, 0, 0, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)bagVersionLabel, gbc);
        this.bagVersionValue = new JLabel("");
        gbc = LayoutUtil.buildGridBagConstraints(3, row, 1, 1, 1, 1, 2, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)this.bagVersionValue, gbc);
        JLabel holeyLabel = new JLabel(this.bagView.getPropertyMessage("bag.label.isholey"));
        holeyLabel.setToolTipText(this.bagView.getPropertyMessage("bag.isholey.help"));
        gbc = LayoutUtil.buildGridBagConstraints(0, ++row, 1, 1, 0, 0, 0, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)holeyLabel, gbc);
        this.holeyValue = new JLabel("");
        gbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 1, 1, 2, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)this.holeyValue, gbc);
        JLabel serializeLabel = new JLabel(this.bagView.getPropertyMessage("bag.label.ispackage"));
        serializeLabel.setToolTipText(this.bagView.getPropertyMessage("bag.serializetype.help"));
        gbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 0, 0, 0, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)serializeLabel, gbc);
        this.serializeValue = new JLabel("");
        gbc = LayoutUtil.buildGridBagConstraints(3, row, 1, 1, 1, 1, 2, 17);
        gbc.insets = new Insets(0, 0, 5, 5);
        pane.add((Component)this.serializeValue, gbc);
        return pane;
    }

    public void setBagVersion(String value) {
        this.bagVersionValue.setText(value);
    }

    public String getBagVersion() {
        return this.bagVersionValue.getText();
    }

    public void setHoley(String value) {
        this.holeyValue.setText(value);
    }

    public void setBagName(String name) {
        if (name == null || name.length() < 1) {
            return;
        }
        this.bagNameValue.setText(name);
    }

    public String getBagName() {
        return this.bagNameValue.getText();
    }

    public void updateInfoForms() {
        this.bagInfoInputPane.populateForms(this.bag);
        this.bagInfoInputPane.enableForms(false);
        this.bagInfoInputPane.invalidate();
    }

    public void updateInfoFormsPane() {
        this.infoPanel.remove(this.bagInfoInputPane);
        this.infoPanel.validate();
        this.bagInfoInputPane = new BagInfoInputPane(this.bagView);
        this.bagInfoInputPane.setToolTipText(this.bagView.getPropertyMessage("bagView.bagInfoInputPane.help"));
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(0, 1, 1, 1, 1, 1, 1, 17);
        this.infoPanel.add((Component)this.bagInfoInputPane, gbc);
        this.validate();
    }

    public void showTabPane(int i) {
        this.bagInfoInputPane.setSelectedIndex(i);
        this.bagInfoInputPane.invalidate();
    }
}

