/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.Contact;
import cool.pandora.modeller.Organization;
import cool.pandora.modeller.ui.BagTableFormBuilder;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.AbstractForm;

public class OrganizationProfileForm
extends AbstractForm
implements FocusListener {
    private static final String PROFILE_FORM_PAGE = "profilePage";
    private JComponent contactName;
    private final BagView bagView;

    public OrganizationProfileForm(FormModel formModel, BagView bagView) {
        super(formModel, PROFILE_FORM_PAGE);
        this.bagView = bagView;
    }

    protected JComponent createFormControl() {
        JPanel form = new JPanel();
        form.setLayout(new BorderLayout());
        JComponent formFields = this.createFormFields();
        form.add((Component)formFields, "Center");
        return form;
    }

    private JComponent createFormFields() {
        BagTableFormBuilder formBuilder = new BagTableFormBuilder(this.getBindingFactory());
        formBuilder.row();
        formBuilder.addSeparator("Send from Organization");
        formBuilder.row();
        JComponent field = formBuilder.add("sourceOrganization")[1];
        Organization organization = this.bagView.getBag().getProfile().getOrganization();
        if (organization != null && organization.getName().isReadOnly()) {
            field.setEnabled(false);
        }
        field.addFocusListener(this);
        formBuilder.row();
        JComponent orgAddress = formBuilder.add("organizationAddress")[1];
        if (organization != null && organization.getAddress().isReadOnly()) {
            field.setEnabled(false);
        }
        orgAddress.addFocusListener(this);
        Contact fromContact = this.bagView.getBag().getProfile().getSendFromContact();
        formBuilder.row();
        formBuilder.addSeparator("Send from Contact");
        formBuilder.row();
        this.contactName = formBuilder.add("srcContactName")[1];
        if (fromContact != null && fromContact.getContactName().isReadOnly()) {
            field.setEnabled(false);
        }
        this.contactName.addFocusListener(this);
        formBuilder.row();
        field = formBuilder.add("srcContactPhone")[1];
        if (fromContact != null && fromContact.getTelephone().isReadOnly()) {
            field.setEnabled(false);
        }
        field.addFocusListener(this);
        formBuilder.row();
        field = formBuilder.add("srcContactEmail")[1];
        if (fromContact != null && fromContact.getEmail().isReadOnly()) {
            field.setEnabled(false);
        }
        field.addFocusListener(this);
        formBuilder.row();
        formBuilder.addSeparator("Send to Contact");
        formBuilder.row();
        field = formBuilder.add("toContactName")[1];
        Contact contact = this.bagView.getBag().getProfile().getSendToContact();
        if (contact != null && contact.getContactName().isReadOnly()) {
            field.setEnabled(false);
        }
        field.addFocusListener(this);
        formBuilder.row();
        field = formBuilder.add("toContactPhone")[1];
        if (contact != null && contact.getTelephone().isReadOnly()) {
            field.setEnabled(false);
        }
        field.addFocusListener(this);
        formBuilder.row();
        field = formBuilder.add("toContactEmail")[1];
        if (contact != null && contact.getEmail().isReadOnly()) {
            field.setEnabled(false);
        }
        field.addFocusListener(this);
        formBuilder.row();
        this.contactName.requestFocus();
        JComponent fieldForm = formBuilder.getForm();
        return fieldForm;
    }

    public boolean requestFocusInWindow() {
        return this.contactName.requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
        if (this.bagView != null && !this.hasErrors() && this.isDirty()) {
            this.bagView.infoInputPane.updateBagHandler.updateBag(this.bagView.getBag());
            this.bagView.infoInputPane.bagInfoInputPane.setSelectedIndex(1);
        }
    }
}

