/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.util;

import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.common.uri.IIIFPathTemplate;
import cool.pandora.modeller.common.uri.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

public class URIResolver {
    private final URI resolvedURI;

    URIResolver(URI resolvedURI) {
        this.resolvedURI = resolvedURI;
    }

    public static ContainerURIResolverNormal resolve() {
        return new ContainerURIResolverNormal();
    }

    public URI render() {
        return this.resolvedURI;
    }

    public static class ContainerURIResolverNormal {
        private Map<String, BagInfoField> map;
        private String containerKey;
        private String resource;
        private int pathType;

        ContainerURIResolverNormal() {
        }

        public ContainerURIResolverNormal map(Map<String, BagInfoField> map) {
            this.map = map;
            return this;
        }

        public ContainerURIResolverNormal pathType(int pathType) {
            this.pathType = pathType;
            return this;
        }

        public ContainerURIResolverNormal containerKey(String containerKey) {
            this.containerKey = containerKey;
            return this;
        }

        public ContainerURIResolverNormal resource(String resource) {
            this.resource = resource;
            return this;
        }

        public static String getMapValue(Map<String, BagInfoField> map, String key) {
            BagInfoField IIIFProfileKey = map.get(key);
            return IIIFProfileKey.getValue();
        }

        static Type getObjectIDPath(int value) {
            IIIFPathTemplate templates = IIIFPathTemplate.BASE_URI_PATH;
            return Type.getByValue(IIIFPathTemplate.class, (int)value);
        }

        static URI resolveURI(Map<String, BagInfoField> map, String containerKey, String resource, int pathType) {
            String hostname = ContainerURIResolverNormal.getMapValue(map, "FedoraHostName");
            Integer port = Integer.parseInt(ContainerURIResolverNormal.getMapValue(map, "Port"));
            if (port == 80) {
                port = -1;
            }
            String appKey = ContainerURIResolverNormal.getMapValue(map, "FedoraAppRoot");
            String restKey = ContainerURIResolverNormal.getMapValue(map, "RestServlet");
            String collectionRoot = ContainerURIResolverNormal.getMapValue(map, "CollectionRoot");
            String collection = ContainerURIResolverNormal.getMapValue(map, "CollectionID");
            String objektID = ContainerURIResolverNormal.getMapValue(map, "ObjektID");
            String manifestLabel = ContainerURIResolverNormal.getMapValue(map, "IIIFManifestResourceLabel");
            Type path = ContainerURIResolverNormal.getObjectIDPath(pathType);
            UriBuilder builder = UriBuilder.fromPath((String)path.toString());
            switch (pathType) {
                case 0: {
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey});
                }
                case 1: {
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey, collectionRoot});
                }
                case 2: {
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey, collectionRoot, collection});
                }
                case 3: {
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey, collectionRoot, collection, objektID});
                }
                case 4: {
                    String container4 = ContainerURIResolverNormal.getMapValue(map, containerKey);
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey, collectionRoot, collection, objektID, container4});
                }
                case 5: {
                    String container5 = ContainerURIResolverNormal.getMapValue(map, containerKey);
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey, collectionRoot, collection, objektID, container5, resource});
                }
                case 6: {
                    return builder.scheme("http").host(hostname).port(port.intValue()).build(new Object[]{appKey, restKey, collectionRoot, collection, objektID, manifestLabel});
                }
            }
            return null;
        }

        public URIResolver build() throws URISyntaxException {
            URI resolvedURI = ContainerURIResolverNormal.resolveURI(this.map, this.containerKey, this.resource, this.pathType);
            return new URIResolver(resolvedURI);
        }
    }
}

