/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.util.ResourceList;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CanvasPageMap {
    private final Map<String, String> canvasPageMap;

    CanvasPageMap(Map<String, String> canvasPageMap) {
        this.canvasPageMap = canvasPageMap;
    }

    public static CanvasPageMapBuilder init() {
        return new CanvasPageMapBuilder();
    }

    public Map<String, String> render() {
        return this.canvasPageMap;
    }

    public static class CanvasPageMapBuilder {
        private List<String> pageIdList;
        private URI canvasContainerURI;

        CanvasPageMapBuilder() {
        }

        public CanvasPageMapBuilder pageIdList(List<String> pageIdList) {
            this.pageIdList = pageIdList;
            return this;
        }

        public CanvasPageMapBuilder canvasContainerURI(URI canvasContainerURI) {
            this.canvasContainerURI = canvasContainerURI;
            return this;
        }

        static Map<String, String> getMap(List<String> pageIdList, URI canvasContainerURI) {
            ResourceList canvasList = new ResourceList(canvasContainerURI);
            ArrayList canvasesList = canvasList.getResourceList();
            Iterator<String> i1 = pageIdList.iterator();
            Iterator i2 = canvasesList.iterator();
            LinkedHashMap<String, String> canvasPageMap = new LinkedHashMap<String, String>();
            while (i1.hasNext() && i2.hasNext()) {
                String pageId = StringUtils.substringAfter((String)i1.next(), (String)"_");
                canvasPageMap.put(pageId, (String)i2.next());
            }
            return canvasPageMap;
        }

        public CanvasPageMap build() throws IOException {
            Map<String, String> canvasPageMap = CanvasPageMapBuilder.getMap(this.pageIdList, this.canvasContainerURI);
            return new CanvasPageMap(canvasPageMap);
        }
    }
}

