/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PageIdMap {
    private final Map<String, String> pageIdMap;

    PageIdMap(Map<String, String> pageIdMap) {
        this.pageIdMap = pageIdMap;
    }

    public static PageIdMapBuilder init() {
        return new PageIdMapBuilder();
    }

    public Map<String, String> render() {
        return this.pageIdMap;
    }

    public static class PageIdMapBuilder {
        private List<String> pageIdList;

        PageIdMapBuilder() {
        }

        public PageIdMapBuilder pageIdList(List<String> pageIdList) {
            this.pageIdList = pageIdList;
            return this;
        }

        static Map<String, String> getPageIdMap(List<String> pageIdList) {
            Iterator<String> i1 = pageIdList.iterator();
            Iterator<String> i2 = pageIdList.iterator();
            LinkedHashMap<String, String> pageIdMap = new LinkedHashMap<String, String>();
            while (i1.hasNext() && i2.hasNext()) {
                String pageId = StringUtils.substringAfter((String)i1.next(), (String)"_");
                pageIdMap.put(pageId, i2.next());
            }
            return pageIdMap;
        }

        public PageIdMap build() throws IOException {
            Map<String, String> pageIdMap = PageIdMapBuilder.getPageIdMap(this.pageIdList);
            return new PageIdMap(pageIdMap);
        }
    }
}

