/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking.ui;

import com.vlsolutions.swing.docking.DockView;
import com.vlsolutions.swing.docking.SplitContainer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;

public class DockViewUI
extends PanelUI {
    protected ViewAncestorListener ancestorListener = new ViewAncestorListener();
    private static DockViewUI instance = new DockViewUI();

    public static ComponentUI createUI(JComponent c) {
        return instance;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.addAncestorListener(this.ancestorListener);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removeAncestorListener(this.ancestorListener);
    }

    protected void installSingleDockableBorder(DockView v) {
        Border b = UIManager.getBorder("DockView.singleDockableBorder");
        v.setBorder(b);
    }

    protected void installTabbedDockableBorder(DockView v) {
        Border b = UIManager.getBorder("DockView.tabbedDockableBorder");
        v.setBorder(b);
    }

    protected void installMaximizedDockableBorder(DockView v) {
        Border b = UIManager.getBorder("DockView.maximizedDockableBorder");
        v.setBorder(b);
    }

    class ViewAncestorListener
    implements AncestorListener {
        ViewAncestorListener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            DockView v = (DockView)ancestorEvent.getComponent();
            Container parent = v.getParent();
            if (parent instanceof TabbedDockableContainer) {
                DockViewUI.this.installTabbedDockableBorder(v);
            } else if (parent instanceof SplitContainer) {
                DockViewUI.this.installSingleDockableBorder(v);
            } else {
                DockViewUI.this.installMaximizedDockableBorder(v);
            }
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

