/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.ProfileField;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class Contact
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ProfileField contactName;
    private ProfileField telephone;
    private ProfileField email;
    public static final String FIELD_CONTACT_NAME = "Contact-Name";
    public static final String FIELD_CONTACT_PHONE = "Contact-Phone";
    public static final String FIELD_CONTACT_EMAIL = "Contact-Email";
    public static final String FIELD_TO_CONTACT_NAME = "To-Contact-Name";
    public static final String FIELD_TO_CONTACT_PHONE = "To-Contact-Phone";
    public static final String FIELD_TO_CONTACT_EMAIL = "To-Contact-Email";
    private static final String FIELD_JSON_NAME = "name";
    private static final String FIELD_JSON_PHONE = "phone";
    private static final String FIELD_JSON_EMAIL = "email";

    public Contact() {
    }

    public Contact(boolean isSentTo) {
        String name = isSentTo ? FIELD_TO_CONTACT_NAME : FIELD_CONTACT_NAME;
        String phone = isSentTo ? FIELD_TO_CONTACT_PHONE : FIELD_CONTACT_PHONE;
        String mail = isSentTo ? FIELD_TO_CONTACT_EMAIL : FIELD_CONTACT_EMAIL;
        this.contactName = new ProfileField();
        this.contactName.setFieldName(name);
        this.telephone = new ProfileField();
        this.telephone.setFieldName(phone);
        this.email = new ProfileField();
        this.email.setFieldName(mail);
    }

    public ProfileField getContactName() {
        return this.contactName;
    }

    public void setContactName(ProfileField name) {
        this.contactName = name;
    }

    public ProfileField getTelephone() {
        return this.telephone;
    }

    public void setTelephone(ProfileField telephone) {
        this.telephone = telephone;
    }

    public ProfileField getEmail() {
        return this.email;
    }

    public void setEmail(ProfileField email) {
        this.email = email;
    }

    public String toString() {
        return "";
    }

    static Contact createContact(JSONObject contactSendToJson, boolean sendTo) throws JSONException {
        Contact contact = new Contact();
        String name = sendTo ? FIELD_TO_CONTACT_NAME : FIELD_CONTACT_NAME;
        String phone = sendTo ? FIELD_TO_CONTACT_PHONE : FIELD_CONTACT_PHONE;
        String email = sendTo ? FIELD_TO_CONTACT_EMAIL : FIELD_CONTACT_EMAIL;
        ProfileField namefield = null;
        ProfileField phonefield = null;
        ProfileField emailfield = null;
        if (contactSendToJson != null) {
            JSONObject emailJson;
            JSONObject phoneJson;
            JSONObject nameJson;
            if (contactSendToJson.has(FIELD_JSON_NAME) && (nameJson = (JSONObject)contactSendToJson.get(FIELD_JSON_NAME)) != null) {
                namefield = ProfileField.createProfileField(nameJson, name);
            }
            if (contactSendToJson.has(FIELD_JSON_PHONE) && (phoneJson = (JSONObject)contactSendToJson.get(FIELD_JSON_PHONE)) != null) {
                phonefield = ProfileField.createProfileField(phoneJson, phone);
            }
            if (contactSendToJson.has(FIELD_JSON_EMAIL) && (emailJson = (JSONObject)contactSendToJson.get(FIELD_JSON_EMAIL)) != null) {
                emailfield = ProfileField.createProfileField(emailJson, email);
            }
        }
        if (namefield == null) {
            namefield = new ProfileField();
            namefield.setFieldName(name);
        }
        if (phonefield == null) {
            phonefield = new ProfileField();
            phonefield.setFieldName(phone);
        }
        if (emailfield == null) {
            emailfield = new ProfileField();
            emailfield.setFieldName(email);
        }
        contact.setContactName(namefield);
        contact.setTelephone(phonefield);
        contact.setEmail(emailfield);
        return contact;
    }

    String serialize() throws JSONException {
        StringWriter writer = new StringWriter();
        JSONWriter contactWriter = new JSONWriter((Writer)writer);
        contactWriter.object().key(FIELD_JSON_NAME).value((Object)new JSONObject(new JSONTokener(this.getContactName().serialize())));
        contactWriter.key(FIELD_JSON_PHONE).value((Object)new JSONObject(new JSONTokener(this.getTelephone().serialize())));
        contactWriter.key(FIELD_JSON_EMAIL).value((Object)new JSONObject(new JSONTokener(this.getEmail().serialize())));
        contactWriter.endObject();
        return writer.toString();
    }
}

