/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.ProfileField;
import java.io.StringWriter;
import java.io.Writer;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class Organization {
    private ProfileField name = new ProfileField();
    private ProfileField address;
    private static final String FIELD_SOURCE_ORGANIZATION = "Source-Organization";
    private static final String FIELD_ORGANIZATION_ADDRESS = "Organization-Address";

    public Organization() {
        this.name.setFieldName(FIELD_SOURCE_ORGANIZATION);
        this.address = new ProfileField();
        this.address.setFieldName(FIELD_ORGANIZATION_ADDRESS);
    }

    public void setName(ProfileField n) {
        this.name = n;
    }

    public ProfileField getName() {
        return this.name;
    }

    private void setAddress(ProfileField a) {
        this.address = a;
    }

    public ProfileField getAddress() {
        return this.address;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean inline) {
        String delim = inline ? ", " : "\n";
        return String.valueOf(this.getName()) + delim + this.getAddress();
    }

    static Organization createOrganization(JSONObject organizationJson) throws JSONException {
        Organization organization = new Organization();
        ProfileField name = null;
        ProfileField address = null;
        if (organizationJson != null) {
            JSONObject jsonObjectOrgAddr;
            JSONObject jsonObjectOrgName;
            if (organizationJson.has(FIELD_SOURCE_ORGANIZATION) && (jsonObjectOrgName = (JSONObject)organizationJson.get(FIELD_SOURCE_ORGANIZATION)) != null) {
                name = ProfileField.createProfileField(jsonObjectOrgName, FIELD_SOURCE_ORGANIZATION);
            }
            if (organizationJson.has(FIELD_ORGANIZATION_ADDRESS) && (jsonObjectOrgAddr = (JSONObject)organizationJson.get(FIELD_ORGANIZATION_ADDRESS)) != null) {
                address = ProfileField.createProfileField(jsonObjectOrgAddr, FIELD_ORGANIZATION_ADDRESS);
            }
        }
        if (name == null) {
            name = new ProfileField();
            name.setFieldName(FIELD_SOURCE_ORGANIZATION);
        }
        if (address == null) {
            address = new ProfileField();
            address.setFieldName(FIELD_ORGANIZATION_ADDRESS);
        }
        organization.setName(name);
        organization.setAddress(address);
        return organization;
    }

    String serialize() throws JSONException {
        StringWriter writer = new StringWriter();
        JSONWriter orgStringer = new JSONWriter((Writer)writer);
        orgStringer.object().key(FIELD_ORGANIZATION_ADDRESS).value((Object)new JSONObject(new JSONTokener(this.getAddress().serialize())));
        orgStringer.key(FIELD_SOURCE_ORGANIZATION).value((Object)new JSONObject(new JSONTokener(this.getName().serialize())));
        orgStringer.endObject();
        return writer.toString();
    }
}

