/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.Contact;
import cool.pandora.modeller.Organization;
import cool.pandora.modeller.ProfileField;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;

public class Profile {
    public static final String NO_PROFILE_NAME = "<no profile>";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_ORGANIZATION = "Organization";
    private static final String FIELD_SENDTO = "Send-To";
    private static final String FIELD_SENDFROM = "Send-From";
    private static final String FIELD_CUSTOM_INFO = "Custom-info";
    private static final String FIELD_STANDARD_INFO = "Standard-info";
    private Contact sendToContact = new Contact(true);
    private Contact sendFromContact = new Contact(false);
    private Organization organization = new Organization();
    private String name;
    private boolean isDefault = false;
    private LinkedHashMap<String, ProfileField> customFields = new LinkedHashMap();
    private LinkedHashMap<String, ProfileField> standardFields = new LinkedHashMap();

    private void setSendToContact(Contact sendToContact) {
        this.sendToContact = sendToContact;
    }

    public Contact getSendToContact() {
        return this.sendToContact;
    }

    private void setSendFromContact(Contact sendFromContact) {
        this.sendFromContact = sendFromContact;
    }

    public Contact getSendFromContact() {
        return this.sendFromContact;
    }

    private void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setName(String profileName) {
        this.name = profileName;
    }

    public String getName() {
        return this.name;
    }

    private void setCustomFields(LinkedHashMap<String, ProfileField> fields) {
        this.customFields = fields;
    }

    public LinkedHashMap<String, ProfileField> getCustomFields() {
        return this.customFields;
    }

    public String toString() {
        return "";
    }

    public static Profile createProfile(JSONObject profileJson, String profileName) throws JSONException {
        Profile profile = new Profile();
        profile.setName(profileName);
        JSONObject organizationJson = null;
        if (profileJson.has(FIELD_ORGANIZATION)) {
            organizationJson = (JSONObject)profileJson.get(FIELD_ORGANIZATION);
        }
        Organization organization = Organization.createOrganization(organizationJson);
        profile.setOrganization(organization);
        JSONObject contactSendToJson = null;
        if (profileJson.has(FIELD_SENDTO)) {
            contactSendToJson = (JSONObject)profileJson.get(FIELD_SENDTO);
        }
        Contact sendToContact = Contact.createContact(contactSendToJson, true);
        profile.setSendToContact(sendToContact);
        JSONObject contactSendFromJson = null;
        if (profileJson.has(FIELD_SENDFROM)) {
            contactSendFromJson = (JSONObject)profileJson.get(FIELD_SENDFROM);
        }
        Contact sendFromContact = Contact.createContact(contactSendFromJson, false);
        profile.setSendFromContact(sendFromContact);
        JSONObject customInfoJson = null;
        if (profileJson.has(FIELD_CUSTOM_INFO)) {
            customInfoJson = (JSONObject)profileJson.get(FIELD_CUSTOM_INFO);
        }
        LinkedHashMap<String, ProfileField> fields = Profile.getFields(customInfoJson);
        profile.setCustomFields(fields);
        LinkedHashMap<String, ProfileField> profileFields = Profile.getFields(profileJson);
        profile.setStandardFields(profileFields);
        return profile;
    }

    private static LinkedHashMap<String, ProfileField> getFields(JSONObject fieldsJson) throws JSONException {
        LinkedHashMap<String, ProfileField> profileFields;
        block5: {
            profileFields = new LinkedHashMap<String, ProfileField>();
            if (fieldsJson == null) break block5;
            String[] names = JSONObject.getNames((JSONObject)fieldsJson);
            if (names == null) {
                return profileFields;
            }
            if (fieldsJson.has("ordered")) {
                JSONArray orderedFields = (JSONArray)fieldsJson.get("ordered");
                for (Object obj : orderedFields) {
                    JSONObject field = (JSONObject)obj;
                    profileFields.putAll(Profile.getFields(field));
                }
            } else {
                for (String name : names) {
                    JSONObject jsonObject = (JSONObject)fieldsJson.get(name);
                    ProfileField profileField = ProfileField.createProfileField(jsonObject, name);
                    profileFields.put(profileField.getFieldName(), profileField);
                }
            }
        }
        return profileFields;
    }

    private void setStandardFields(LinkedHashMap<String, ProfileField> standardFields) {
        this.standardFields = standardFields;
    }

    public LinkedHashMap<String, ProfileField> getStandardFields() {
        return this.standardFields;
    }

    public void setIsDefault() {
        this.isDefault = true;
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    public void serialize(JSONWriter jsonWriter) throws JSONException {
        JSONWriter writer = jsonWriter.object().key(FIELD_NAME).value((Object)this.getName());
        String orgStringer = this.getOrganization().serialize();
        String fromContact = this.getSendFromContact().serialize();
        String toContact = this.getSendToContact().serialize();
        String localCustomFields = Profile.seralizeFields(this.getCustomFields().values());
        String localStandardFields = Profile.seralizeFields(this.getStandardFields().values());
        writer.key(FIELD_ORGANIZATION).value((Object)new JSONObject(new JSONTokener(orgStringer)));
        writer.key(FIELD_SENDFROM).value((Object)new JSONObject(new JSONTokener(fromContact)));
        writer.key(FIELD_SENDTO).value((Object)new JSONObject(new JSONTokener(toContact)));
        writer.key(FIELD_CUSTOM_INFO).value((Object)new JSONObject(new JSONTokener(localCustomFields)));
        writer.key(FIELD_STANDARD_INFO).value((Object)new JSONObject(new JSONTokener(localStandardFields)));
        writer.endObject();
    }

    private static String seralizeFields(Collection<ProfileField> profileFields) throws JSONException {
        StringWriter writer = new StringWriter();
        JSONWriter filedWriter = new JSONWriter((Writer)writer);
        filedWriter.object();
        for (ProfileField field : profileFields) {
            String fieldStringer = field.serialize();
            filedWriter.key(field.getFieldName()).value((Object)new JSONObject(new JSONTokener(fieldStringer)));
        }
        filedWriter.endObject();
        return writer.toString();
    }

    public boolean isNoProfile() {
        return NO_PROFILE_NAME.equals(this.getName());
    }

    public List<ProfileField> getProfileFields() {
        ArrayList<ProfileField> fields = new ArrayList<ProfileField>();
        for (Map.Entry<String, ProfileField> entry : this.standardFields.entrySet()) {
            fields.add(entry.getValue());
        }
        for (Map.Entry<String, ProfileField> entry : this.customFields.entrySet()) {
            fields.add(entry.getValue());
        }
        return fields;
    }
}

