/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class ProfileField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fieldName = "";
    private String fieldValue = "";
    private String fieldType = "";
    private boolean isReadOnly = false;
    private List<String> elements = new ArrayList<String>();
    private boolean isRequired;
    private boolean isValueRequired;
    private static final String FIELD_REQUIRED_VALUE = "requiredValue";
    private static final String FIELD_REQUIRED = "fieldRequired";
    private static final String FIELD_TYPE = "fieldType";
    private static final String FIELD_READ_ONLY = "isReadOnly";
    private static final String FIELD_DEFAULT_VALUE = "defaultValue";
    private static final String FIELD_VALUE_LIST = "valueList";

    void setFieldName(String s) {
        this.fieldName = s;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    private void setIsRequired(boolean b) {
        this.isRequired = b;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setFieldValue(String s) {
        this.fieldValue = s;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    private void setElements(List<String> s) {
        this.elements = s;
    }

    public List<String> getElements() {
        return this.elements;
    }

    private void setFieldType(String s) {
        this.fieldType = s;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setIsValueRequired(boolean b) {
        this.isValueRequired = b;
    }

    public boolean getIsValueRequired() {
        return this.isValueRequired;
    }

    public String toString() {
        return this.fieldName + '=' + this.fieldValue + '\n';
    }

    private void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    static ProfileField createProfileField(JSONObject profileFieldJson, String name) throws JSONException {
        ProfileField profileField = new ProfileField();
        profileField.setFieldName(name);
        if (profileFieldJson != null) {
            if (profileFieldJson.has(FIELD_TYPE)) {
                String fieldType = (String)profileFieldJson.get(FIELD_TYPE);
                profileField.setFieldType(fieldType);
            }
            if (profileFieldJson.has(FIELD_REQUIRED_VALUE)) {
                String fieldValue = (String)profileFieldJson.get(FIELD_REQUIRED_VALUE);
                profileField.setFieldValue(fieldValue);
            }
            if (profileFieldJson.has(FIELD_READ_ONLY)) {
                boolean isreadOnly = (Boolean)profileFieldJson.get(FIELD_READ_ONLY);
                profileField.setReadOnly(isreadOnly);
            }
            if (profileFieldJson.has(FIELD_VALUE_LIST)) {
                JSONArray jsonArray = (JSONArray)profileFieldJson.get(FIELD_VALUE_LIST);
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String value = (String)jsonArray.get(i);
                    valueList.add(value);
                }
                profileField.setElements(valueList);
                profileField.setFieldValue((String)valueList.get(0));
            }
            if (profileFieldJson.has(FIELD_DEFAULT_VALUE)) {
                String defaultValue = (String)profileFieldJson.get(FIELD_DEFAULT_VALUE);
                profileField.setFieldValue(defaultValue);
            }
            if (profileFieldJson.has(FIELD_REQUIRED)) {
                boolean isRequired = (Boolean)profileFieldJson.get(FIELD_REQUIRED);
                profileField.setIsRequired(isRequired);
            }
        }
        return profileField;
    }

    public static ProfileField createProfileField(String name, String value) {
        ProfileField profileField = new ProfileField();
        profileField.setFieldName(name);
        profileField.setFieldValue(value);
        return profileField;
    }

    String serialize() throws JSONException {
        StringWriter writer = new StringWriter();
        JSONWriter profileWriter = new JSONWriter((Writer)writer);
        profileWriter.object().key(FIELD_REQUIRED_VALUE).value((Object)this.getFieldValue());
        profileWriter.key(FIELD_REQUIRED).value(this.getIsRequired());
        profileWriter.key(FIELD_TYPE).value((Object)this.getFieldType());
        profileWriter.key(FIELD_READ_ONLY).value(this.isReadOnly());
        if (this.getElements().size() > 0) {
            profileWriter.key(FIELD_VALUE_LIST).value(this.getElements());
        }
        profileWriter.endObject();
        return writer.toString();
    }
}

