/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.domain;

import cool.pandora.modeller.Bagger;
import cool.pandora.modeller.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSonBagger
implements Bagger {
    protected static final Logger log = LoggerFactory.getLogger(JSonBagger.class);
    private File profilesFolder;
    private static final String BAGGER_PROFILES_HOME_PROPERTY = "BAGGER_PROFILES_HOME";
    private static final String RESOURCE_DIR = "profiles";
    private static final String[] DEFAULT_PROFILES = new String[]{"fedora-iiif-profile.json"};

    public JSonBagger() {
        String homeDir = System.getProperty("user.home");
        if (System.getProperties().containsKey(BAGGER_PROFILES_HOME_PROPERTY)) {
            homeDir = System.getProperty(BAGGER_PROFILES_HOME_PROPERTY);
        }
        String profilesPath = homeDir + File.separator + "cool.pandora.modeller";
        log.info("Using cool.pandora.modeller.profiles from {}", (Object)profilesPath);
        this.profilesFolder = new File(profilesPath);
        this.copyDefautprofilesToUserFolder(this.profilesFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDefautprofilesToUserFolder(File folder) {
        if (!folder.exists()) {
            boolean madeDirs = folder.mkdirs();
            log.debug("Made directories {} ? {}", (Object)folder, (Object)madeDirs);
        }
        for (String profile : DEFAULT_PROFILES) {
            InputStream inputStream = null;
            try {
                String resource = "profiles/" + profile;
                log.debug("Getting profile {} from jar", (Object)resource);
                inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
                if (inputStream == null) {
                    log.error("Tried to read {} from jar file but failed!", (Object)resource);
                }
                log.debug("Checking if {} exists", (Object)profile);
                File target = new File(folder, profile);
                if (!target.exists()) {
                    log.debug("Profile {} does not already exist on the filesystem. Copying it from jar", (Object)profile);
                    Files.copy(inputStream, target.toPath(), new CopyOption[0]);
                }
                JSonBagger.closeStream(inputStream);
            }
            catch (Exception e) {
                log.error("Failed to copy profile {}", (Object)profile, (Object)e);
                break;
            }
            finally {
                JSonBagger.closeStream(inputStream);
            }
        }
    }

    private static void closeStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadProfile(String profileName) {
    }

    @Override
    public List<Profile> loadProfiles() {
        File[] profilesFiles = this.profilesFolder.listFiles();
        ArrayList<Profile> profilesToReturn = new ArrayList<Profile>();
        if (profilesFiles != null) {
            for (File file : profilesFiles) {
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    Profile profile = JSonBagger.loadProfile(reader, file.getName());
                    profilesToReturn.add(profile);
                }
                catch (FileNotFoundException e) {
                    log.error("Could not find profile file[{}]!", (Object)file, (Object)e);
                }
                catch (JSONException e) {
                    log.error("Error parsing json profile[{}]!", (Object)file, (Object)e);
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Expected UTF-8 encoded file for {}", (Object)file, (Object)e);
                }
            }
        }
        Profile profile = new Profile();
        profile.setName("<no profile>");
        profile.setIsDefault();
        profilesToReturn.add(profile);
        return profilesToReturn;
    }

    private static Profile loadProfile(Reader reader, String jsonFileName) throws JSONException {
        JSONTokener tokenizer = new JSONTokener(reader);
        JSONObject jsonObject = new JSONObject(tokenizer);
        return Profile.createProfile(jsonObject, JSonBagger.getprofileName(jsonFileName));
    }

    @Override
    public void saveProfile(Profile profile) {
        if (profile.getName().equals("<no profile>")) {
            return;
        }
        try {
            String fileName = JSonBagger.getJsonFileName(profile.getName());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.profilesFolder.getAbsolutePath() + File.separator + fileName), Charset.forName("UTF-8"));
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            profile.serialize(jsonWriter);
            JSONObject jsonObject = new JSONObject(new JSONTokener(stringWriter.toString()));
            writer.write(jsonObject.toString(4));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            log.error("Failed to write profile {}", (Object)profile.getName(), (Object)e);
        }
        catch (JSONException e) {
            log.error("Failed to write JSON", (Throwable)e);
        }
    }

    private static String getprofileName(String jsonFileName) {
        return jsonFileName.substring(0, jsonFileName.indexOf("-profile.json"));
    }

    private static String getJsonFileName(String name) {
        return name + "-profile.json";
    }

    @Override
    public void removeProfile(Profile profile) {
        String homeDir = System.getProperty("user.home");
        String profilesPath = homeDir + File.separator + "cool.pandora.modeller";
        this.profilesFolder = new File(profilesPath);
        String profileFielName = JSonBagger.getJsonFileName(profile.getName());
        File file = new File(this.profilesFolder, profileFielName);
        if (file.exists()) {
            boolean wasDeleted = file.delete();
            log.debug("File {} was deleted ? {}", (Object)file, (Object)wasDeleted);
        }
    }
}

