/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.core.DocumentLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    protected static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory((ObjectCodec)JSON_MAPPER);
    private static DocumentLoader DOCUMENT_LOADER = new DocumentLoader();

    public static Object fromInputStream(InputStream input) throws IOException {
        return JsonUtils.fromInputStream(input, "UTF-8");
    }

    public static Object fromInputStream(InputStream input, String enc) throws IOException {
        return JsonUtils.fromReader(new BufferedReader(new InputStreamReader(input, enc)));
    }

    public static Object fromReader(Reader reader) throws IOException {
        JsonToken t;
        Object rval;
        JsonParser jp = JSON_FACTORY.createParser(reader);
        JsonToken initialToken = jp.nextToken();
        if (initialToken == JsonToken.START_ARRAY) {
            rval = jp.readValueAs(List.class);
        } else if (initialToken == JsonToken.START_OBJECT) {
            rval = jp.readValueAs(Map.class);
        } else if (initialToken == JsonToken.VALUE_STRING) {
            rval = jp.readValueAs(String.class);
        } else if (initialToken == JsonToken.VALUE_FALSE || initialToken == JsonToken.VALUE_TRUE) {
            rval = jp.readValueAs(Boolean.class);
        } else if (initialToken == JsonToken.VALUE_NUMBER_FLOAT || initialToken == JsonToken.VALUE_NUMBER_INT) {
            rval = jp.readValueAs(Number.class);
        } else if (initialToken == JsonToken.VALUE_NULL) {
            rval = null;
        } else {
            throw new JsonParseException("document doesn't start with a valid json element : " + initialToken, jp.getCurrentLocation());
        }
        try {
            t = jp.nextToken();
        }
        catch (JsonParseException ex) {
            throw new JsonParseException("Document contains more content after json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        if (t != null) {
            throw new JsonParseException("Document contains possible json content after the json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        return rval;
    }

    public static Object fromString(String jsonString) throws JsonParseException, IOException {
        return JsonUtils.fromReader(new StringReader(jsonString));
    }

    public static Object fromURL(URL url) throws JsonParseException, IOException {
        return DOCUMENT_LOADER.fromURL(url);
    }

    public static String toPrettyString(Object jsonObject) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonUtils.writePrettyPrint(sw, jsonObject);
        return sw.toString();
    }

    public static String toString(Object jsonObject) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonUtils.write(sw, jsonObject);
        return sw.toString();
    }

    public static void write(Writer writer, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer);
        jw.writeObject(jsonObject);
    }

    public static void writePrettyPrint(Writer writer, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer);
        jw.useDefaultPrettyPrinter();
        jw.writeObject(jsonObject);
    }

    static {
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    }
}

