/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer;

import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.transfer.FetchFailStrategy;
import gov.loc.repository.bagit.transfer.FetchFailureAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class ThresholdFailStrategy
implements FetchFailStrategy {
    private int totalFailureThreshold;
    private int fileFailureThreshold;
    private int totalFailures = 0;
    private Map<String, Integer> failures = new HashMap<String, Integer>();

    public int getTotalFailureThreshold() {
        return this.totalFailureThreshold;
    }

    public int getTotalFailures() {
        return this.totalFailures;
    }

    public void setTotalFailureThreshold(int totalFailureThreshold) {
        if (totalFailureThreshold < 0) {
            throw new IllegalArgumentException(MessageFormat.format("TotalFailureThreshold cannot be negative: {0}", totalFailureThreshold));
        }
        if (totalFailureThreshold == Integer.MAX_VALUE) {
            throw new IllegalArgumentException(MessageFormat.format("TotalFailureThreshold must be less than MAX_INT: {0}", totalFailureThreshold));
        }
        this.totalFailureThreshold = totalFailureThreshold;
    }

    public int getFileFailureThreshold() {
        return this.fileFailureThreshold;
    }

    public void setFileFailureThreshold(int fileFailureThreshold) {
        if (fileFailureThreshold < 0) {
            throw new IllegalArgumentException(MessageFormat.format("FileFailureThreshold cannot be negative: {0}", fileFailureThreshold));
        }
        if (fileFailureThreshold == Integer.MAX_VALUE) {
            throw new IllegalArgumentException(MessageFormat.format("FileFailureThreshold must be less than MAX_INT: {0}", fileFailureThreshold));
        }
        this.fileFailureThreshold = fileFailureThreshold;
    }

    public ThresholdFailStrategy() {
    }

    public ThresholdFailStrategy(int fileFailureThreshold, int totalFailureThreshold) {
        this.setFileFailureThreshold(fileFailureThreshold);
        this.setTotalFailureThreshold(totalFailureThreshold);
    }

    @Override
    public synchronized FetchFailureAction registerFailure(FetchTxt.FilenameSizeUrl fetchLine, Object context) {
        FetchFailureAction action;
        if (++this.totalFailures >= this.totalFailureThreshold) {
            action = FetchFailureAction.STOP;
        } else {
            Integer fileFailures = this.failures.get(fetchLine.getFilename());
            if (fileFailures == null) {
                fileFailures = 0;
            }
            fileFailures = fileFailures + 1;
            this.failures.put(fetchLine.getFilename(), fileFailures);
            action = fileFailures >= this.fileFailureThreshold ? FetchFailureAction.CONTINUE_WITH_NEXT : FetchFailureAction.RETRY_CURRENT;
        }
        return action;
    }
}

