/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.repository.bagit.transfer.BagTransferCancelledException;
import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.fetch.FetchStreamCopier;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalRsyncFetchProtocol
implements FetchProtocol {
    public static final String PROP_RSYNC_BINARY = "RsyncBinary";
    private static final Log log = LogFactory.getLog(ExternalRsyncFetchProtocol.class);
    private String rsyncPath = System.getProperty("RsyncBinary");
    private boolean sanityChecked = false;

    public ExternalRsyncFetchProtocol() {
        if (this.rsyncPath == null) {
            this.rsyncPath = "rsync";
        }
    }

    @Override
    public ExternalRsyncFetcher createFetcher(URI uri, Long size) throws BagTransferException {
        this.checkRsyncSanity();
        return new ExternalRsyncFetcher();
    }

    public synchronized void checkRsyncSanity() throws BagTransferException {
        if (!this.sanityChecked) {
            this.sanityChecked = true;
            log.debug((Object)MessageFormat.format("Checking for sanity of rsync: {0}", this.rsyncPath));
            CommandLine commandLine = CommandLine.parse((String)this.rsyncPath);
            commandLine.addArgument("--version");
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM));
                log.trace((Object)MessageFormat.format("Executing test command line: {0}", commandLine));
                int result = executor.execute(commandLine);
                if (result == 0) {
                    log.debug((Object)"Rsync test successful.");
                } else {
                    log.warn((Object)MessageFormat.format("{0}: returned non-zero exit code during sanity check: {1}", this.rsyncPath, result));
                }
            }
            catch (ExecuteException e) {
                throw new BagTransferException(MessageFormat.format("Unable to execute rsync: {0}", this.rsyncPath), e);
            }
            catch (IOException e) {
                throw new BagTransferException(MessageFormat.format("Unable to execute rsync: {0}", this.rsyncPath), e);
            }
        }
    }

    private class ExternalRsyncFetcher
    extends LongRunningOperationBase
    implements FileFetcher {
        private SimpleProcessDestroyer processDestroyer;

        private ExternalRsyncFetcher() {
        }

        @Override
        public void initialize() throws BagTransferException {
        }

        @Override
        public void close() {
        }

        @Override
        public void setPassword(String password) {
        }

        @Override
        public void setUsername(String username) {
        }

        @Override
        public void cancel() {
            super.cancel();
            SimpleProcessDestroyer destroyer = this.processDestroyer;
            if (destroyer != null) {
                destroyer.destroyProcesses();
            }
        }

        @Override
        public void fetchFile(URI uri, Long size, FetchedFileDestination destination, FetchContext context) throws BagTransferException {
            File downloadFile;
            try {
                if (destination.getSupportsDirectAccess()) {
                    log.trace((Object)"Creating direct-access file in destination location.");
                    downloadFile = new File(destination.getDirectAccessPath());
                    File containingDirectory = downloadFile.getParentFile();
                    if (!containingDirectory.exists()) {
                        log.trace((Object)MessageFormat.format("Creating directory: {0}", containingDirectory.getAbsolutePath()));
                        if (!containingDirectory.mkdirs()) {
                            log.debug((Object)MessageFormat.format("Unable to create parent directory when downloading file (Maybe somebody created it before us?): {0}", destination.getDirectAccessPath()));
                        }
                    }
                } else {
                    log.warn((Object)"File destination does not support direct-access files.  Temporary data will be downloaded to the system temp location, and then copied into its final location.");
                    String baseName = FilenameUtils.getBaseName((String)destination.getFilepath());
                    downloadFile = File.createTempFile(baseName, "-bagit.tmp");
                }
                log.trace((Object)MessageFormat.format("Created rsync destination file: {0}", downloadFile.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new BagTransferException("Unable to create temp file.", e);
            }
            String srcUriString = this.decodeUri(uri);
            CommandLine commandLine = CommandLine.parse((String)ExternalRsyncFetchProtocol.this.rsyncPath);
            commandLine.addArgument("--quiet");
            commandLine.addArgument("--times");
            commandLine.addArgument(srcUriString, false);
            commandLine.addArgument(this.getLocalPath(downloadFile), false);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, (OutputStream)err);
            OutputStream destinationStream = null;
            BufferedInputStream tempStream = null;
            try {
                DefaultExecutor executor = new DefaultExecutor();
                executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
                this.processDestroyer = new SimpleProcessDestroyer();
                executor.setProcessDestroyer((ProcessDestroyer)this.processDestroyer);
                log.debug((Object)MessageFormat.format("Executing: {0}", commandLine.toString()));
                executor.execute(commandLine);
                log.trace((Object)"External process exited successfully.");
                if (!destination.getSupportsDirectAccess()) {
                    log.debug((Object)"Destination does not support direct access.  Copying from temporary location to destination.");
                    log.trace((Object)"Opening destination.");
                    destinationStream = destination.openOutputStream(false);
                    log.trace((Object)"Opening destination file.");
                    tempStream = new BufferedInputStream(new FileInputStream(downloadFile));
                    log.trace((Object)"Copying temp file to destination.");
                    FetchStreamCopier copier = new FetchStreamCopier("Copying from temp", destination.getFilepath(), downloadFile.length());
                    this.delegateProgress(copier);
                    long bytesCopied = copier.copy(tempStream, destinationStream);
                    log.debug((Object)MessageFormat.format("Successfully copied {0} bytes.", bytesCopied));
                }
            }
            catch (ExecuteException e) {
                if (this.isCancelled()) {
                    throw new BagTransferCancelledException();
                }
                String error = new String(err.toByteArray(), StandardCharsets.UTF_8);
                String msg = MessageFormat.format("An error occurred while executing command line \"{0}\": {1}", commandLine.toString(), error);
                throw new BagTransferException(msg, e);
            }
            catch (IOException e) {
                if (this.isCancelled()) {
                    throw new BagTransferCancelledException();
                }
                throw new BagTransferException(MessageFormat.format("Unexpected exception when executing command: {0}", commandLine.toString()));
            }
            finally {
                IOUtils.closeQuietly(tempStream);
                IOUtils.closeQuietly(destinationStream);
                if (!destination.getSupportsDirectAccess()) {
                    log.trace((Object)"Deleting temporary file.");
                    if (!downloadFile.delete()) {
                        log.trace((Object)"Unable to delete temporary file.  Marking for delete on exit.");
                        downloadFile.deleteOnExit();
                    }
                }
            }
        }

        private String decodeUri(URI uri) throws BagTransferException {
            String uriString = uri.toString();
            try {
                uriString = URLDecoder.decode(uriString, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BagTransferException(e);
            }
            return uriString;
        }

        private String getLocalPath(File file) {
            String finalPath;
            if (OS.isFamilyWindows()) {
                finalPath = FilenameUtils.separatorsToUnix((String)file.getAbsolutePath());
                log.trace((Object)MessageFormat.format("Final path: {0}", finalPath));
            } else {
                finalPath = file.getAbsolutePath();
                log.trace((Object)MessageFormat.format("Not on Windows.  Final path is: {0}", finalPath));
            }
            return finalPath;
        }

        private class SimpleProcessDestroyer
        implements ProcessDestroyer {
            private ArrayList<Process> processesToKill = new ArrayList(1);

            private SimpleProcessDestroyer() {
            }

            public void destroyProcesses() {
                for (Process process : this.processesToKill) {
                    process.destroy();
                }
            }

            public boolean add(Process process) {
                return this.processesToKill.add(process);
            }

            public boolean remove(Process process) {
                return this.processesToKill.remove(process);
            }

            public int size() {
                return this.processesToKill.size();
            }
        }
    }
}

