/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyAccessException;
import org.springframework.richclient.application.ApplicationLauncher;

final class ModellerApplication {
    protected static final Logger log = LoggerFactory.getLogger(ModellerApplication.class);

    private ModellerApplication() {
    }

    public static void main(String[] args) {
        String rootContextDirectoryClassPath = "cool/pandora/modeller/ctx";
        String startupContextPath = "cool/pandora/modeller/ctx/common/richclient-startup-context.xml";
        String richclientApplicationContextPath = "cool/pandora/modeller/ctx/common/richclient-application-context.xml";
        String businessLayerContextPath = "cool/pandora/modeller/ctx/common/business-layer-context.xml";
        try {
            new ApplicationLauncher("cool/pandora/modeller/ctx/common/richclient-startup-context.xml", new String[]{"cool/pandora/modeller/ctx/common/richclient-application-context.xml", "cool/pandora/modeller/ctx/common/business-layer-context.xml"});
        }
        catch (IllegalStateException ex1) {
            log.error("IllegalStateException during startup", (Throwable)ex1);
            JOptionPane.showMessageDialog(new JFrame(), "An illegal state error occured.\n", "Bagger startup error!", 0);
            System.exit(1);
        }
        catch (PropertyAccessException ex) {
            log.error("PropertyAccessException during startup", (Throwable)ex);
            JOptionPane.showMessageDialog(new JFrame(), "An error occured loading properties.\n", "Bagger startup error!", 0);
            System.exit(1);
        }
        catch (RuntimeException e) {
            log.error("RuntimeException during startup", (Throwable)e);
            String msg = e.getMessage();
            if (msg.contains("SAXParseException")) {
                JOptionPane.showMessageDialog(new JFrame(), "An error occured parsing application context.  You may have no internet access.\n", "Bagger startup error!", 0);
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "An error occured during startup.\n", "Bagger startup error!", 0);
            }
            System.exit(1);
        }
    }
}

