/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import java.awt.Color;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagTextPane
extends JTextPane {
    private static final long serialVersionUID = -505900021814525136L;
    protected static final Logger log = LoggerFactory.getLogger(BagTextPane.class);
    private StyledDocument document;
    private String message = "";

    BagTextPane(String message) {
        this.message = message;
        this.buildDocument();
        this.setStyledDocument(this.document);
        this.setAutoscrolls(true);
        this.setEditable(false);
        Color textBackground = new Color(240, 240, 240);
        this.setBackground(textBackground);
    }

    public void setMessage(String message) {
        this.message = message;
        this.buildDocument();
        this.setStyledDocument(this.document);
    }

    public String getMessage() {
        return this.message;
    }

    private void buildDocument() {
        StyleContext context = new StyleContext();
        this.document = new DefaultStyledDocument(context);
        Style style = context.getStyle("default");
        StyleConstants.setAlignment(style, 0);
        StyleConstants.setFontSize(style, 14);
        StyleConstants.setSpaceAbove(style, 4.0f);
        StyleConstants.setSpaceBelow(style, 4.0f);
        try {
            this.document.insertString(this.document.getLength(), this.message, style);
        }
        catch (BadLocationException badLocationException) {
            log.error(badLocationException.getMessage());
        }
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setBold(attributes, true);
        StyleConstants.setItalic(attributes, true);
        Style labelStyle = context.getStyle("default");
        ImageIcon icon = new ImageIcon("Computer.gif");
        JLabel label = new JLabel(icon);
        StyleConstants.setComponent(labelStyle, label);
    }
}

