/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.BagTextPane;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import gov.loc.repository.bagit.BagFile;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagManifestPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(TagManifestPane.class);
    private final BagView parentView;
    private DefaultBag defaultBag;
    private final Dimension preferredDimension = new Dimension(600, 480);
    private final Color selectedColor = Color.lightGray;
    private final Color unselectedColor = Color.black;

    public TagManifestPane(BagView bagView) {
        this.parentView = bagView;
        this.defaultBag = bagView.getBag();
        this.populateBagPane();
    }

    private void init() {
        this.setPreferredSize(this.preferredDimension);
        ChangeListener changeListener = changeEvent -> {
            JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
            int count = sourceTabbedPane.getTabCount();
            int selected = sourceTabbedPane.getSelectedIndex();
            for (int i = 0; i < count; ++i) {
                Color c = i == selected ? this.unselectedColor : this.selectedColor;
                sourceTabbedPane.setBackgroundAt(i, c);
                sourceTabbedPane.setForegroundAt(i, c);
            }
        };
        this.addChangeListener(changeListener);
    }

    public void setBag(DefaultBag bag) {
        this.defaultBag = bag;
    }

    public DefaultBag getBag() {
        return this.defaultBag;
    }

    private void populateBagPane() {
        Collection list = this.defaultBag.getTags();
        ArrayList<BagTextPane> manifestPaneList = new ArrayList<BagTextPane>();
        ArrayList<JScrollPane> manifestScrollPaneList = new ArrayList<JScrollPane>();
        log.info("TagManifestPane.populateBagPane getTags: {}", (Object)list.size());
        for (BagFile bf : list) {
            String content = bf.getFilepath().contains("manifest") ? bf.toString() : TagManifestPane.tokenFormat(bf.toString());
            log.debug("BagFile: {}::{}", (Object)bf.getFilepath(), (Object)content);
            BagTextPane manifestPane = new BagTextPane(content);
            manifestPaneList.add(manifestPane);
            JScrollPane manifestScrollPane = new JScrollPane();
            manifestScrollPane.setViewportView(manifestPane);
            manifestScrollPane.setToolTipText(this.parentView.getPropertyMessage("compositePane.tab.manifest.help"));
            manifestScrollPane.setForeground(this.selectedColor);
            manifestScrollPaneList.add(manifestScrollPane);
            String tabName = bf.getFilepath();
            log.debug("manifestName: {}", (Object)tabName);
            this.addTab(tabName, manifestScrollPane);
        }
        JScrollPane dataScrollPane = new JScrollPane();
        String dataContent = this.defaultBag.getDataContent();
        BagTextPane dataPane = new BagTextPane(dataContent);
        dataScrollPane.setViewportView(dataPane);
        dataScrollPane.setToolTipText(this.parentView.getPropertyMessage("compositePane.tab.data.help"));
        dataScrollPane.setForeground(this.selectedColor);
        if (!this.defaultBag.isHoley()) {
            this.addTab(this.parentView.getPropertyMessage("compositePane.tab.data"), dataScrollPane);
        }
        this.init();
    }

    public void updateCompositePaneTabs(DefaultBag defaultBag) {
        this.setBag(defaultBag);
        if (this.getComponentCount() > 0) {
            this.removeAll();
            this.invalidate();
        }
        this.populateBagPane();
        int count = this.getTabCount();
        int selected = this.getSelectedIndex();
        for (int i = 0; i < count; ++i) {
            Color c = i == selected ? this.unselectedColor : this.selectedColor;
            this.setBackgroundAt(i, c);
            this.setForegroundAt(i, c);
        }
        this.invalidate();
    }

    private static String tokenFormat(String content) {
        StringBuilder buffer = new StringBuilder();
        StringTokenizer st = new StringTokenizer(content, ",", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            buffer.append(s);
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

